/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.crafting.recipes;

import io.lumine.mythic.lib.api.crafting.ingredients.MythicIngredient;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicRecipeIngredient;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicRecipeInventory;
import io.lumine.mythic.lib.api.crafting.ingredients.ShapelessItem;
import io.lumine.mythic.lib.api.crafting.ingredients.ShapelessRequester;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipe;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipeStation;
import io.lumine.mythic.lib.api.crafting.recipes.VanillaBookableRecipe;
import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.util.Ref;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShapelessRecipe
extends MythicRecipe
implements VanillaBookableRecipe {
    public ShapelessRecipe(@NotNull String name, @NotNull ArrayList<MythicRecipeIngredient> ingredients) {
        super(name, ingredients);
    }

    public ShapelessRecipe(@NotNull String name, MythicRecipeIngredient ... ingredients) {
        super(name, ingredients);
    }

    @Override
    public void addIngredient(@NotNull MythicRecipeIngredient ingredient) {
        this.mythicIngredients.add(ingredient);
    }

    @Override
    @NotNull
    public MythicRecipeStation getType() {
        return MythicRecipeStation.WORKBENCH;
    }

    @Override
    @Nullable
    public MythicRecipeInventory matches(@NotNull MythicRecipeInventory inventory, @Nullable Ref<Integer> timesToCompletion) {
        ArrayList<MythicIngredient> ingredients = new ArrayList<MythicIngredient>();
        for (MythicRecipeIngredient rIngredient : this.getIngredients()) {
            ingredients.add(rIngredient.getIngredient());
        }
        ArrayList<ShapelessItem> result = this.matches(this.pool(inventory), ingredients);
        if (result != null) {
            MythicRecipeInventory ret = inventory.clone();
            int leastTimes = Short.MAX_VALUE;
            for (ShapelessItem resultItem : result) {
                int finalAmount;
                int difference;
                int originalAmount;
                int times;
                ItemStack stacc = ret.getItemAt(resultItem.getOriginalWidthCoord(), resultItem.getOriginalHeightCoord());
                Validate.isTrue((stacc != null ? 1 : 0) != 0, (String)"Original coordinates mismatch in shapeless recipe: Result item cannot point to an original null");
                if (timesToCompletion != null && leastTimes > (times = SilentNumbers.floor((double)(originalAmount = stacc.getAmount()) / (double)(difference = originalAmount - (finalAmount = resultItem.getAmount()))))) {
                    leastTimes = times;
                }
                stacc.setAmount(resultItem.getAmount());
            }
            Ref.setValue(timesToCompletion, leastTimes);
            return ret;
        }
        return null;
    }

    @Nullable
    public ArrayList<ShapelessItem> matches(@NotNull ArrayList<ShapelessItem> pool, @NotNull ArrayList<MythicIngredient> unmatchedIngredients) {
        ArrayList<ShapelessRequester> dibbers = new ArrayList<ShapelessRequester>();
        int rOID = 0;
        for (MythicIngredient mythicIngredient : unmatchedIngredients) {
            ShapelessRequester check = new ShapelessRequester(rOID, mythicIngredient);
            ++rOID;
            dibbers.add(check);
            for (ShapelessItem ingredient : pool) {
                Ref<ArrayList<ProvidedUIFilter>> match = new Ref<ArrayList<ProvidedUIFilter>>();
                FriendlyFeedbackProvider ffp = null;
                if (!check.getIngredient().matches(ingredient.getStack(), true, match, true, ffp)) continue;
                Collections.sort((List)match.getValue());
                check.dib(ingredient, match.getValue().get(0));
            }
        }
        for (ShapelessItem shapelessItem : pool) {
            if (shapelessItem.getRequesters().size() != 0) continue;
            return null;
        }
        ArrayList<ShapelessRequester> ambiguouslyFulfilled = new ArrayList<ShapelessRequester>();
        for (ShapelessRequester requester : dibbers) {
            if (!requester.firstClaim()) {
                return null;
            }
            if (requester.isFulfilled()) continue;
            ambiguouslyFulfilled.add(requester);
        }
        if (ambiguouslyFulfilled.size() == 0) {
            return pool;
        }
        ShapelessRequester shapelessRequester = (ShapelessRequester)ambiguouslyFulfilled.get(0);
        ArrayList<ArrayList<ShapelessItem>> alternativePools = shapelessRequester.secondClaim(ShapelessItem.completeCloneList(pool));
        Validate.isTrue((alternativePools.size() > 0 ? 1 : 0) != 0, (String)"Fatal Error when evaluating shapeless recipe: Alternative Pools Array Size Equals 0, which is ridiculous.");
        ArrayList<MythicIngredient> alternativeIngredients = new ArrayList<MythicIngredient>();
        for (int r = 1; r < ambiguouslyFulfilled.size(); ++r) {
            ShapelessRequester observed = (ShapelessRequester)ambiguouslyFulfilled.get(r);
            alternativeIngredients.add(observed.getIngredient());
        }
        for (ArrayList<ShapelessItem> alternativePool : alternativePools) {
            ArrayList<ShapelessItem> ret = this.matches(alternativePool, alternativeIngredients);
            if (ret == null) continue;
            for (ShapelessItem alternative : ret) {
                for (ShapelessItem original : pool) {
                    if (alternative.getOperationalIdentifier() != original.getOperationalIdentifier()) continue;
                    int currentA = original.getTaken();
                    int finalA = alternative.getTaken();
                    int deltaA = finalA - currentA;
                    original.take(deltaA);
                }
            }
            return pool;
        }
        return null;
    }

    @NotNull
    public ArrayList<ShapelessItem> pool(@NotNull MythicRecipeInventory inventory) {
        ArrayList<ShapelessItem> ret = new ArrayList<ShapelessItem>();
        int oid = 0;
        for (int w = 0; w < inventory.getWidth(); ++w) {
            for (int h = 0; h < inventory.getHeight(); ++h) {
                ItemStack at = inventory.getItemAt(w, -h);
                if (SilentNumbers.isAir(at)) continue;
                ret.add(new ShapelessItem(oid, at, w, -h));
                ++oid;
            }
        }
        return ret;
    }

    @Override
    @NotNull
    public Recipe getBukkitRecipe(@NotNull NamespacedKey recipeName, @NotNull ItemStack recipeResult) throws IllegalArgumentException {
        org.bukkit.inventory.ShapelessRecipe ret = new org.bukkit.inventory.ShapelessRecipe(recipeName, recipeResult);
        for (MythicRecipeIngredient ingredient : this.getIngredients()) {
            if (ingredient == null) continue;
            ret.addIngredient(ingredient.toBukkit());
        }
        return ret;
    }
}

