/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.placeholders;

import io.lumine.mythic.lib.api.placeholders.MythicPlaceholder;
import io.lumine.mythic.lib.comp.placeholder.MythicPlaceholderAPIHook;
import java.util.ArrayList;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MythicPlaceholders {
    @NotNull
    static final ArrayList<MythicPlaceholder> objectParsers = new ArrayList();

    @NotNull
    public static String parse(@NotNull String str, Object ... objects) {
        if (!str.contains("%")) {
            return str;
        }
        for (Object o : objects) {
            ArrayList<MythicPlaceholder> parsers;
            if (o == null || (parsers = MythicPlaceholders.getParserFor(o)).isEmpty()) continue;
            for (MythicPlaceholder p : parsers) {
                String result;
                if (p == null || (result = MythicPlaceholders.parseWithPlaceholder(str, o, p)) == null) continue;
                str = result;
            }
        }
        return str;
    }

    @Nullable
    public static String parseWithPlaceholder(@NotNull String str, @NotNull Object o, @NotNull MythicPlaceholder parser) {
        if (!str.contains("%")) {
            return null;
        }
        if (!parser.forUseWith(o)) {
            return null;
        }
        if (parser instanceof MythicPlaceholderAPIHook && o instanceof OfflinePlayer) {
            return parser.parse(str, o);
        }
        @NotNull String builtIdentifier = "%" + parser.getMythicIdentifier() + "_";
        @NotNull String[] args = str.split(builtIdentifier);
        @NotNull StringBuilder built = new StringBuilder();
        boolean within = false;
        for (String arg : args) {
            if (!within) {
                within = true;
                built.append(arg);
            }
            if (arg == null) continue;
            int percentEnd = arg.indexOf("%");
            if (percentEnd < 0) {
                built.append(builtIdentifier).append(arg);
                continue;
            }
            String parsing = arg.substring(0, percentEnd);
            String parsed = parser.parse(parsing, o);
            if (parsed == null) {
                built.append(builtIdentifier).append(arg);
                continue;
            }
            String rem = arg.substring(percentEnd + 1);
            built.append(parsed).append(rem);
        }
        return built.toString();
    }

    @NotNull
    public static ArrayList<MythicPlaceholder> getParserFor(@NotNull Object obj) {
        ArrayList<MythicPlaceholder> ret = new ArrayList<MythicPlaceholder>();
        for (MythicPlaceholder mp : objectParsers) {
            if (mp == null || !mp.forUseWith(obj)) continue;
            ret.add(mp);
        }
        return ret;
    }

    public static void registerPlaceholder(@NotNull MythicPlaceholder placeholder) {
        for (MythicPlaceholder mp : objectParsers) {
            if (!mp.getMythicIdentifier().equals(placeholder.getMythicIdentifier())) continue;
            return;
        }
        objectParsers.add(placeholder);
    }
}

