/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.stat.modifier;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.player.modifier.ModifierSource;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import io.lumine.mythic.lib.player.modifier.PlayerModifier;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import java.text.DecimalFormat;
import org.apache.commons.lang.Validate;

public class StatModifier
extends PlayerModifier {
    private final String stat;
    private final double value;
    private final ModifierType type;
    private static final DecimalFormat oneDigit = MythicLib.plugin.getMMOConfig().newDecimalFormat("0.#");

    public StatModifier(String key, String stat, double value) {
        this(key, stat, value, ModifierType.FLAT, EquipmentSlot.OTHER, ModifierSource.OTHER);
    }

    public StatModifier(String key, String stat, double value, ModifierType type) {
        this(key, stat, value, type, EquipmentSlot.OTHER, ModifierSource.OTHER);
    }

    public StatModifier(String key, String stat, double value, ModifierType type, EquipmentSlot slot, ModifierSource source) {
        super(key, slot, source);
        this.stat = stat;
        this.value = value;
        this.type = type;
    }

    public StatModifier(String key, String stat, String str) {
        super(key, EquipmentSlot.OTHER, ModifierSource.OTHER);
        Validate.notNull((Object)str, (String)"String cannot be null");
        Validate.notEmpty((String)str, (String)"String cannot be empty");
        this.type = str.toCharArray()[str.length() - 1] == '%' ? ModifierType.RELATIVE : ModifierType.FLAT;
        this.value = Double.parseDouble(this.type == ModifierType.RELATIVE ? str.substring(0, str.length() - 1) : str);
        this.stat = stat;
    }

    public StatModifier(ConfigObject object) {
        super(object.getString("key"), EquipmentSlot.OTHER, ModifierSource.OTHER);
        this.stat = object.getString("stat");
        this.value = object.getDouble("value");
        this.type = object.getBoolean("multiplicative", false) ? ModifierType.RELATIVE : ModifierType.FLAT;
    }

    public String getStat() {
        return this.stat;
    }

    public ModifierType getType() {
        return this.type;
    }

    public double getValue() {
        return this.value;
    }

    public StatModifier add(double offset) {
        return new StatModifier(this.getKey(), this.stat, this.value + offset, this.type, this.getSlot(), this.getSource());
    }

    public StatModifier multiply(double coef) {
        return new StatModifier(this.getKey(), this.stat, this.value * coef, this.type, this.getSlot(), this.getSource());
    }

    @Override
    public void register(MMOPlayerData playerData) {
        playerData.getStatMap().getInstance(this.stat).addModifier(this);
    }

    @Override
    public void unregister(MMOPlayerData playerData) {
        playerData.getStatMap().getInstance(this.stat).remove(this.getKey());
    }

    public String toString() {
        return oneDigit.format(this.value) + (this.type == ModifierType.RELATIVE ? "%" : "");
    }
}

