/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.stat.modifier;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.modifier.StatModifier;
import io.lumine.mythic.lib.player.modifier.Closeable;
import io.lumine.mythic.lib.player.modifier.ModifierSource;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import org.apache.commons.lang.Validate;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TemporaryStatModifier
extends StatModifier
implements Closeable {
    private BukkitRunnable closeTask;
    private long duration;
    private long startTime;

    public TemporaryStatModifier(String key, String stat, double value, ModifierType type, EquipmentSlot slot, ModifierSource source) {
        super(key, stat, value, type, slot, source);
    }

    public long getDuration() {
        Validate.isTrue((boolean)this.isActive(), (String)"Modifier is not active");
        return this.duration;
    }

    public long getStartTime() {
        Validate.isTrue((boolean)this.isActive(), (String)"Modifier is not active");
        return this.startTime;
    }

    public void register(final MMOPlayerData playerData, long duration) {
        Validate.isTrue((!this.isActive() ? 1 : 0) != 0, (String)"Modifier is already active");
        super.register(playerData);
        this.closeTask = new BukkitRunnable(){

            public void run() {
                TemporaryStatModifier.this.unregister(playerData);
            }
        };
        this.closeTask.runTaskLater((Plugin)MythicLib.plugin, duration);
        this.duration = duration;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void register(MMOPlayerData playerData) {
        throw new UnsupportedOperationException("Use #register(MMOPlayerData, long) instead");
    }

    @Override
    public void close() {
        Validate.isTrue((boolean)this.isActive(), (String)"Modifier is not active");
        this.closeTask.cancel();
        this.closeTask = null;
    }

    public boolean isActive() {
        return this.closeTask != null;
    }
}

