/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.command.api;

import io.lumine.mythic.lib.command.api.CommandTreeExplorer;
import io.lumine.mythic.lib.command.api.CommandTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public abstract class CommandTreeRoot
extends CommandTreeNode
implements CommandExecutor,
TabCompleter {
    private final String permission;

    public CommandTreeRoot(String id, String permission) {
        super(null, id);
        this.permission = permission;
    }

    @Override
    public CommandTreeNode.CommandResult execute(CommandSender sender, String[] args) {
        return CommandTreeNode.CommandResult.THROW_USAGE;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission(this.permission)) {
            return false;
        }
        CommandTreeNode explorer = new CommandTreeExplorer(this, args).getNode();
        if (explorer.execute(sender, args) == CommandTreeNode.CommandResult.THROW_USAGE) {
            explorer.calculateUsageList().forEach(str -> sender.sendMessage(ChatColor.YELLOW + "/" + str));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission(this.permission)) {
            return new ArrayList<String>();
        }
        List<String> list = new CommandTreeExplorer(this, args).calculateTabCompletion();
        return args[args.length - 1].isEmpty() ? list : list.stream().filter(string -> string.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

