/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.comp.adventure;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.comp.adventure.argument.AdventureArgument;
import io.lumine.mythic.lib.comp.adventure.argument.AdventureArgumentQueue;
import io.lumine.mythic.lib.comp.adventure.argument.EmptyArgumentQueue;
import io.lumine.mythic.lib.comp.adventure.resolver.ContextTagResolver;
import io.lumine.mythic.lib.comp.adventure.tag.AdventureTag;
import io.lumine.mythic.lib.comp.adventure.tag.implementation.AdventureColorTag;
import io.lumine.mythic.lib.comp.adventure.tag.implementation.GradientTag;
import io.lumine.mythic.lib.comp.adventure.tag.implementation.HexColorTag;
import io.lumine.mythic.lib.comp.adventure.tag.implementation.NewlineTag;
import io.lumine.mythic.lib.comp.adventure.tag.implementation.RainbowTag;
import io.lumine.mythic.lib.comp.adventure.tag.implementation.TransitionTag;
import io.lumine.mythic.lib.comp.adventure.tag.implementation.VanillaColorTag;
import io.lumine.mythic.lib.comp.adventure.tag.implementation.decorations.BoldTag;
import io.lumine.mythic.lib.comp.adventure.tag.implementation.decorations.ItalicTag;
import io.lumine.mythic.lib.comp.adventure.tag.implementation.decorations.ObfuscatedTag;
import io.lumine.mythic.lib.comp.adventure.tag.implementation.decorations.ResetTag;
import io.lumine.mythic.lib.comp.adventure.tag.implementation.decorations.StrikethroughTag;
import io.lumine.mythic.lib.comp.adventure.tag.implementation.decorations.UnderlineTag;
import io.lumine.mythic.lib.math3.util.Pair;
import io.lumine.mythic.lib.util.AdventureUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class AdventureParser {
    private static final Pattern TAG_REGEX = Pattern.compile("(?i)(?<=<).*?(?=>)");
    private static final Pattern HEX_REGEX = Pattern.compile("(?i)(#|HEX)[0-9a-f]{6}");
    private final List<AdventureTag> tags = new ArrayList<AdventureTag>();

    @ApiStatus.Internal
    public AdventureParser(boolean testing) {
    }

    public AdventureParser() {
        this.add(new GradientTag());
        this.add(new RainbowTag());
        this.add(new TransitionTag());
        this.add(new VanillaColorTag());
        this.add(new HexColorTag());
        this.add(new AdventureColorTag());
        this.add(new NewlineTag());
        this.add(new BoldTag());
        this.add(new ItalicTag());
        this.add(new ObfuscatedTag());
        this.add(new ResetTag());
        this.add(new StrikethroughTag());
        this.add(new UnderlineTag());
    }

    @NotNull
    public String parse(@NotNull String src) {
        String cpy = src;
        Matcher matcher = TAG_REGEX.matcher(cpy);
        while (matcher.find()) {
            String tag = matcher.group();
            String tagName = tag.contains(":") ? tag.split(":")[0] : tag;
            String finalCpy = cpy;
            if (tagName.isEmpty() || tagName.startsWith("/")) continue;
            cpy = this.findByName(tagName).map(adventureTag -> this.parseTag(finalCpy, (AdventureTag)adventureTag, tagName, tag)).orElseGet(() -> {
                Matcher matcher1 = HEX_REGEX.matcher(tag);
                if (!matcher1.find()) {
                    return finalCpy;
                }
                String prefix = matcher1.group(1);
                return this.findByName(prefix).map(adventureTag -> this.parseTag(finalCpy, (AdventureTag)adventureTag, prefix, tag)).orElse(finalCpy);
            });
        }
        cpy = this.removeUnparsedAndUselessTags(cpy);
        return this.minecraftColorization(cpy);
    }

    @NotNull
    public CompletableFuture<String> parseAsync(@NotNull String src) {
        return AdventureUtils.supplyAsync(() -> this.parse(src));
    }

    @NotNull
    public Collection<String> parse(@NotNull Collection<String> src) {
        List parsed = src.stream().map(this::parse).collect(Collectors.toList());
        ArrayList<String> finalList = new ArrayList<String>();
        for (String line : parsed) {
            if (!line.contains("\n")) {
                finalList.add(line);
                continue;
            }
            finalList.addAll(Arrays.asList(line.split("\n")));
        }
        return finalList;
    }

    @NotNull
    public CompletableFuture<Collection<String>> parseAsync(@NotNull Collection<String> src) {
        return AdventureUtils.supplyAsync(() -> this.parse(src));
    }

    @NotNull
    private String parseTag(@NotNull String src, @NotNull AdventureTag tag, @NotNull String tagIdentifier, @NotNull String plainTag) {
        String cpy = src;
        try {
            String rawTag;
            String hexPrefix;
            int firstArgIndex = plainTag.indexOf(":");
            boolean hasArgs = firstArgIndex != -1;
            boolean isHex = tagIdentifier.equals("#") || tagIdentifier.equalsIgnoreCase("HEX");
            String string = hexPrefix = tagIdentifier.startsWith("#") ? "#" : "HEX";
            String string2 = isHex ? tagIdentifier : (rawTag = plainTag.substring(0, hasArgs ? firstArgIndex : plainTag.length()));
            String rawArgs = isHex ? plainTag.substring(hexPrefix.length()) : (hasArgs ? plainTag.substring(firstArgIndex + 1) : "");
            String original = String.format("<%s%s>", rawTag, hasArgs ? ':' + rawArgs : rawArgs);
            AdventureArgumentQueue args = this.parseArguments(rawArgs);
            boolean hasContext = tag.resolver() instanceof ContextTagResolver;
            String context = hasContext ? this.getTagContent(cpy, rawTag, original) : null;
            Pair<List<String>, String> contextDecorations = hasContext ? this.processContextDecorations(context) : null;
            String resolved = hasContext ? ((ContextTagResolver)tag.resolver()).resolve(rawTag, args, contextDecorations.getValue(), contextDecorations.getKey()) : tag.resolver().resolve(rawTag, args);
            cpy = cpy.replace(hasContext ? String.format("%s%s", original, context) : original, resolved != null ? resolved : "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cpy;
    }

    @NotNull
    private String getTagContent(@NotNull String src, @NotNull String tagName, @NotNull String tagIdentifier) {
        String closeTag = String.format("</%s>", tagName);
        String content = StringUtils.substringBetween((String)src, (String)tagIdentifier, (String)closeTag);
        if (content != null) {
            return content;
        }
        String cpy = src.substring(src.indexOf(tagIdentifier) + tagIdentifier.length());
        int colorIndex = cpy.length();
        Matcher matcher = TAG_REGEX.matcher(cpy);
        int iterations = 0;
        while (matcher.find() && iterations++ < 10) {
            String rawTag = matcher.group();
            String[] split = rawTag.split(":");
            Optional<AdventureTag> optTag = this.findByName(split[0]).filter(AdventureTag::color);
            if (optTag.isPresent()) {
                colorIndex = cpy.indexOf(String.format("<%s>", rawTag));
                break;
            }
            matcher = TAG_REGEX.matcher(cpy);
        }
        content = cpy.substring(0, colorIndex);
        return content;
    }

    private AdventureArgumentQueue parseArguments(@NotNull String rawArgs) {
        String[] unparsedArgs = rawArgs.split(":");
        if (unparsedArgs.length > 0 && unparsedArgs[0].isEmpty()) {
            unparsedArgs = Arrays.copyOfRange(unparsedArgs, 1, unparsedArgs.length);
        }
        return new AdventureArgumentQueue(Arrays.stream(unparsedArgs).map(AdventureArgument::new).collect(Collectors.toList()));
    }

    @NotNull
    private String removeUnparsedAndUselessTags(@NotNull String src) {
        Matcher matcher = TAG_REGEX.matcher(src);
        int iterations = 0;
        while (matcher.find() && iterations++ < 50) {
            String matched = matcher.group();
            String original = String.format("<%s>", matched);
            if (matched.startsWith("/")) {
                src = src.replace(original, "\u00a7r");
            }
            matcher = TAG_REGEX.matcher(src);
        }
        return src;
    }

    @NotNull
    private String minecraftColorization(@NotNull String src) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)src);
    }

    @NotNull
    public String stripColors(@NotNull String src) {
        String cpy = this.minecraftColorization(src);
        Matcher matcher = TAG_REGEX.matcher(src);
        while (matcher.find()) {
            String tag = matcher.group();
            String original = String.format("<%s>", tag);
            cpy = cpy.replace(original, "");
        }
        return ChatColor.stripColor((String)cpy);
    }

    @NotNull
    public String lastColor(@NotNull String src, boolean matchDecorations) {
        String lastTag;
        String cpy = this.minecraftColorization(src);
        LinkedList<Map.Entry<AdventureTag, String>> tags = new LinkedList<Map.Entry<AdventureTag, String>>();
        Matcher matcher = TAG_REGEX.matcher(cpy);
        while (matcher.find()) {
            String tag = matcher.group();
            String tagName = tag.contains(":") ? tag.split(":")[0] : tag;
            if (tagName.isEmpty() || tagName.startsWith("/")) continue;
            Optional<AdventureTag> opt = this.findByName(tagName);
            if (opt.isPresent()) {
                tags.add(new AbstractMap.SimpleEntry<AdventureTag, String>(opt.get(), tag));
                continue;
            }
            Matcher matcher1 = HEX_REGEX.matcher(tag);
            if (!matcher1.find()) continue;
            this.findByName(matcher1.group(1)).ifPresent(adventureTag -> tags.add(new AbstractMap.SimpleEntry<AdventureTag, String>((AdventureTag)adventureTag, tag)));
        }
        String vanilla = this.getLastLegacyColor(cpy, matchDecorations);
        if (tags.isEmpty()) {
            return vanilla;
        }
        String string = lastTag = matchDecorations ? this.getSurroundingDecorations(src, tags) : this.getLastColorTag(tags);
        if (lastTag == null) {
            return "";
        }
        if (vanilla.isEmpty()) {
            return lastTag;
        }
        return cpy.indexOf(vanilla) > cpy.indexOf(lastTag) ? vanilla : lastTag;
    }

    @Nullable
    private String getLastColorTag(LinkedList<Map.Entry<AdventureTag, String>> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Map.Entry<AdventureTag, String> entry = list.get(i);
            if (!entry.getKey().color()) continue;
            return String.format("<%s>", entry.getValue());
        }
        return null;
    }

    @Nullable
    private String getSurroundingDecorations(@NotNull String src, @NotNull LinkedList<Map.Entry<AdventureTag, String>> list) {
        int index;
        String colorTag = this.getLastColorTag(list);
        if (colorTag == null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Map.Entry<AdventureTag, String> entry = list.get(i);
                if (entry.getKey().color()) continue;
                return String.format("<%s>", entry.getValue());
            }
            return null;
        }
        int tagIndex = src.indexOf(colorTag);
        ArrayList<String> previousTags = new ArrayList<String>();
        String before = src.substring(0, tagIndex);
        if (before.length() > 3 && before.charAt(before.length() - 1) == '>') {
            while (before.length() > 3 && before.charAt(before.length() - 1) == '>' && (index = before.lastIndexOf(60)) != -1 && !this.findByName(before.substring(index + 1, before.length() - 1).split(":")[0]).filter(AdventureTag::color).isPresent() && !before.substring(index).startsWith("</")) {
                previousTags.add(0, before.substring(index));
                before = before.substring(0, index);
            }
        }
        ArrayList<String> nextTags = new ArrayList<String>();
        String after = src.substring(tagIndex + colorTag.length());
        if (after.length() > 3 && after.charAt(0) == '<') {
            while (after.length() > 3 && after.charAt(0) == '<' && (index = after.indexOf(62)) != -1 && !this.findByName(after.substring(1, index).split(":")[0]).filter(AdventureTag::color).isPresent() && !after.substring(0, index).startsWith("</")) {
                nextTags.add(after.substring(0, index + 1));
                after = after.substring(index + 1);
            }
        }
        StringBuilder builder = new StringBuilder();
        previousTags.forEach(builder::append);
        builder.append(colorTag);
        nextTags.forEach(builder::append);
        return builder.toString();
    }

    @NotNull
    private Pair<List<String>, String> processContextDecorations(@NotNull String context) {
        HashMap decorations = new HashMap();
        String cpy = this.minecraftColorization(context);
        Matcher matcher = TAG_REGEX.matcher(cpy);
        while (matcher.find()) {
            String tag = matcher.group();
            String tagName = tag.contains(":") ? tag.split(":")[0] : tag;
            if (tagName.isEmpty() || tagName.startsWith("/")) continue;
            this.findByName(tagName).filter(t -> !t.color()).map(t -> t.resolver().resolve("", new EmptyArgumentQueue())).ifPresent(s -> decorations.put(tag, s));
        }
        for (Map.Entry e : decorations.entrySet()) {
            context = context.replace(String.format("<%s>", e.getKey()), "");
        }
        return Pair.create(new ArrayList(decorations.values()), context);
    }

    @NotNull
    private String getLastLegacyColor(@NotNull String input, boolean matchDecorations) {
        StringBuilder builder = new StringBuilder();
        int length = input.length();
        for (int index = length - 1; index > -1; --index) {
            char c;
            ChatColor color;
            char section = input.charAt(index);
            if (section != '\u00a7' || index >= length - 1 || (color = ChatColor.getByChar((char)(c = input.charAt(index + 1)))) == null || color.isFormat() && !matchDecorations) continue;
            builder.insert(0, color);
            if (color.isColor() || color.equals((Object)ChatColor.RESET)) break;
        }
        return builder.toString();
    }

    public void add(AdventureTag tag) {
        if (tag.backwardsCompatible() && MythicLib.plugin.getVersion().isBelowOrEqual(1, 15)) {
            MythicLib.plugin.getLogger().warning(String.format("The tag %s is not compatible with your server version.", tag.name()));
            return;
        }
        this.tags.add(tag);
    }

    @ApiStatus.Internal
    public void forceRegister(AdventureTag tag) {
        this.tags.add(tag);
    }

    public void remove(AdventureTag tag) {
        this.tags.remove(tag);
    }

    public Optional<AdventureTag> findByName(@NotNull String name) {
        return this.tags.stream().filter(tag -> tag.name().equalsIgnoreCase(name) || tag.aliases().stream().anyMatch(s -> s.equalsIgnoreCase(name))).findFirst();
    }

    public List<AdventureTag> tags() {
        return this.tags;
    }
}

