/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.comp.adventure.argument;

import io.lumine.mythic.lib.comp.adventure.argument.AdventureArgument;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class AdventureArgumentQueue {
    private final List<AdventureArgument> args;
    private int ptr = 0;

    public AdventureArgumentQueue(@NotNull List<AdventureArgument> args) {
        this.args = args;
    }

    @NotNull
    public AdventureArgument pop() {
        if (!this.hasNext()) {
            throw new IllegalStateException("Missing argument for this tag!");
        }
        return this.args.get(this.ptr++);
    }

    @NotNull
    public AdventureArgument popOr(@NotNull String errorMessage) {
        if (!this.hasNext()) {
            throw new IllegalArgumentException(errorMessage);
        }
        return this.args.get(this.ptr++);
    }

    @NotNull
    public AdventureArgument popOr(@NotNull Supplier<String> errorMessage) {
        if (!this.hasNext()) {
            throw new IllegalArgumentException(errorMessage.get());
        }
        return this.args.get(this.ptr++);
    }

    @NotNull
    public AdventureArgument peek() {
        return this.hasNext() ? this.args.get(this.ptr) : null;
    }

    public boolean hasNext() {
        return this.ptr < this.args.size();
    }

    public void reset() {
        this.ptr = 0;
    }

    public String toString() {
        return this.args.toString();
    }
}

