/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.comp.mythicmobs.mechanic;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.damage.DamagingMechanic;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.stat.provider.StatProvider;
import io.lumine.mythic.lib.damage.AttackMetadata;
import io.lumine.mythic.lib.damage.DamageMetadata;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.element.Element;
import io.lumine.mythic.lib.player.PlayerMetadata;
import java.io.File;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MythicMechanic(author="Indyuce", name="mmodamage", aliases={"mmod", "mmodmg"}, description="Deals damage to the target (compatible with MMO plugins)")
public class MMODamageMechanic
extends DamagingMechanic
implements ITargetedEntitySkill {
    protected final PlaceholderDouble amount;
    protected final boolean ignoreMMOAttack;
    protected final DamageType[] types;
    @Nullable
    private final String elementName;

    @Deprecated
    public MMODamageMechanic(SkillExecutor manager, String file, MythicLineConfig mlc) {
        this(manager, new File(file), mlc.getLine(), mlc);
    }

    public MMODamageMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.amount = PlaceholderDouble.of((String)mlc.getString(new String[]{"amount", "a"}, "1", new String[0]));
        String typesString = mlc.getString(new String[]{"type", "t", "types"}, null, new String[0]);
        this.ignoreMMOAttack = mlc.getBoolean(new String[]{"ignoreMMOAttack", "immo"}, false);
        this.elementName = mlc.getString(new String[]{"element", "el", "e"}, null, new String[0]);
        this.types = typesString == null || typesString.isEmpty() || "NONE".equalsIgnoreCase(typesString) ? new DamageType[]{} : this.toDamageTypeArray(typesString);
    }

    @NotNull
    private DamageType[] toDamageTypeArray(String typesString) {
        String[] split = typesString.split("\\,");
        DamageType[] array = new DamageType[split.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = DamageType.valueOf(UtilityMethods.enumName(split[i]));
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        AttackMetadata currentAttack;
        Element element;
        if (target.isDead() || !(target.getBukkitEntity() instanceof LivingEntity) || data.getCaster().isUsingDamageSkill() || target.getHealth() <= 0.0) {
            return SkillResult.INVALID_TARGET;
        }
        double damage = this.amount.get((PlaceholderMeta)data, target) * (double)data.getPower();
        Element element2 = element = this.elementName != null ? Objects.requireNonNull(MythicLib.plugin.getElements().get(UtilityMethods.enumName(this.elementName)), "Could not find element with ID '" + this.elementName + "'") : null;
        if (!this.ignoreMMOAttack && (currentAttack = MythicLib.plugin.getDamage().getRegisteredAttackMetadata(target.getBukkitEntity())) != null) {
            if (element == null) {
                currentAttack.getDamage().add(damage, this.types);
            } else {
                currentAttack.getDamage().add(damage, element, this.types);
            }
            return SkillResult.SUCCESS;
        }
        Entity attackerBukkit = data.getCaster().getEntity().getBukkitEntity();
        PlayerMetadata attacker = data.getVariables().has("MMOStatMap") ? (PlayerMetadata)data.getVariables().get("MMOStatMap").get() : (attackerBukkit instanceof LivingEntity ? StatProvider.get((LivingEntity)attackerBukkit, EquipmentSlot.MAIN_HAND, true) : null);
        DamageMetadata damageMeta = element == null ? new DamageMetadata(damage, this.types) : new DamageMetadata(damage, element, this.types);
        AttackMetadata attackMeta = new AttackMetadata(damageMeta, (LivingEntity)target.getBukkitEntity(), attacker);
        MythicLib.plugin.getDamage().markAsMetadata(attackMeta);
        try {
            this.doDamage(data.getCaster(), target, damage);
        }
        catch (Exception exception) {
            MythicLib.plugin.getLogger().log(Level.SEVERE, "Caught an exception (4) while damaging entity '" + target.getUniqueId() + "':");
            exception.printStackTrace();
        }
        finally {
            MythicLib.plugin.getDamage().unmarkAsMetadata(attackMeta);
        }
        return SkillResult.SUCCESS;
    }
}

