/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.comp.mythicmobs.mechanic;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.damage.AttackMetadata;
import io.lumine.mythic.lib.damage.DamageType;
import java.util.Objects;

@MythicMechanic(author="Indyuce", name="multiplydamage", aliases={"multdamage", "multdmg"}, description="Increases damage of current attack by a certain factor")
public class MultiplyDamageMechanic
implements INoTargetSkill {
    protected final PlaceholderDouble amount;
    protected final DamageType type;
    protected final boolean additive;

    public MultiplyDamageMechanic(MythicLineConfig config) {
        this.amount = PlaceholderDouble.of((String)config.getString(new String[]{"amount", "a"}, "1", new String[0]));
        String typeFormat = config.getString(new String[]{"type", "t"}, "", new String[0]);
        this.type = typeFormat.isEmpty() ? null : DamageType.valueOf(typeFormat.toUpperCase().replace(" ", "_").replace("-", "_"));
        this.additive = config.getBoolean("additive", false);
    }

    public SkillResult cast(SkillMetadata skillMetadata) {
        for (AbstractEntity target : skillMetadata.getEntityTargets()) {
            AttackMetadata attackMeta = Objects.requireNonNull(MythicLib.plugin.getDamage().getRegisteredAttackMetadata(target.getBukkitEntity()));
            if (attackMeta == null) continue;
            double a = this.amount.get((PlaceholderMeta)skillMetadata);
            if (this.additive) {
                if (this.type == null) {
                    attackMeta.getDamage().additiveModifier(a);
                    continue;
                }
                attackMeta.getDamage().additiveModifier(a, this.type);
                continue;
            }
            if (this.type == null) {
                attackMeta.getDamage().multiplicativeModifier(a);
                continue;
            }
            attackMeta.getDamage().multiplicativeModifier(a, this.type);
        }
        return SkillResult.SUCCESS;
    }
}

