/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.hologram;

import io.lumine.mythic.lib.hologram.HologramFactory;
import io.lumine.mythic.lib.hologram.factory.CMIHologramFactory;
import io.lumine.mythic.lib.hologram.factory.DecentHologramFactory;
import io.lumine.mythic.lib.hologram.factory.HDHologramFactory;
import io.lumine.mythic.lib.hologram.factory.HologramsHologramFactory;
import io.lumine.mythic.lib.hologram.factory.TrHologramFactory;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicePriority;

public enum HologramFactoryList {
    HOLOGRAPHIC_DISPLAYS("HolographicDisplays", HDHologramFactory.class, ServicePriority.High),
    DECENT_HOLOGRAMS("DecentHolograms", DecentHologramFactory.class, ServicePriority.Normal),
    HOLOGRAMS("Holograms", HologramsHologramFactory.class, ServicePriority.Normal),
    CMI("CMI", CMIHologramFactory.class, ServicePriority.Low),
    TR_HOLOGRAM("TrHologram", TrHologramFactory.class, ServicePriority.Normal);

    private final String pluginName;
    private final Class<? extends HologramFactory> factoryClass;
    private final ServicePriority priority;

    private HologramFactoryList(String pluginName, Class<? extends HologramFactory> factoryClass, ServicePriority priority) {
        this.pluginName = pluginName;
        this.factoryClass = factoryClass;
        this.priority = priority;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public boolean isInstalled(PluginManager manager) {
        return manager.getPlugin(this.pluginName) != null;
    }

    public HologramFactory generateFactory() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return this.factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public ServicePriority getServicePriority() {
        return this.priority;
    }
}

