/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.hologram.factory;

import com.Zrips.CMI.CMI;
import io.lumine.mythic.lib.hologram.Hologram;
import io.lumine.mythic.lib.hologram.HologramFactory;
import java.util.List;
import java.util.UUID;
import net.Zrips.CMILib.Container.CMILocation;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;

public class CMIHologramFactory
implements HologramFactory {
    @Override
    public Hologram newHologram(Location loc, List<String> lines) {
        return new CMIHologram(loc, lines);
    }

    public class CMIHologram
    implements Hologram {
        private final com.Zrips.CMI.Modules.Holograms.CMIHologram holo;
        private boolean spawned = true;

        public CMIHologram(Location loc, List<String> list) {
            this.holo = new com.Zrips.CMI.Modules.Holograms.CMIHologram("MythicLib-" + UUID.randomUUID().toString(), new CMILocation(loc));
            this.holo.setLines(list);
            CMI.getInstance().getHologramManager().addHologram(this.holo);
            this.holo.update();
        }

        @Override
        public void updateLines(List<String> list) {
            this.holo.setLines(list);
            this.holo.update();
        }

        @Override
        public Location getLocation() {
            return this.holo.getLocation();
        }

        @Override
        public void despawn() {
            Validate.isTrue((boolean)this.spawned, (String)"Hologram is already despawned");
            CMI.getInstance().getHologramManager().removeHolo(this.holo);
            this.spawned = false;
        }

        @Override
        public boolean isSpawned() {
            return this.spawned;
        }

        @Override
        public void updateLocation(Location loc) {
            this.holo.setLoc(loc);
            this.holo.update();
        }

        @Override
        public List<String> getLines() {
            return this.holo.getLines();
        }
    }
}

