/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.listener;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.event.AttackEvent;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.damage.DamageMetadata;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.util.DefenseFormula;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.NotNull;

public class DamageReduction
implements Listener {
    private static final Set<EntityDamageEvent.DamageCause> FIRE_DAMAGE_CAUSES = new HashSet<EntityDamageEvent.DamageCause>(Arrays.asList(EntityDamageEvent.DamageCause.FIRE, EntityDamageEvent.DamageCause.FIRE_TICK, EntityDamageEvent.DamageCause.LAVA, EntityDamageEvent.DamageCause.MELTING));

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void damageMitigation(AttackEvent event) {
        if (!UtilityMethods.isRealPlayer((Entity)event.getEntity())) {
            return;
        }
        MMOPlayerData data = MMOPlayerData.get((OfflinePlayer)event.getEntity());
        for (SpecificDamageReductionType specificDamageReductionType : SpecificDamageReductionType.values()) {
            specificDamageReductionType.applyReduction(data.getStatMap(), event.getDamage(), event.toBukkit());
        }
        for (Enum enum_ : DamageType.values()) {
            event.getDamage().multiplicativeModifier(1.0 - data.getStatMap().getStat(enum_ + "_DAMAGE_REDUCTION") / 100.0, (DamageType)enum_);
        }
        double defense = data.getStatMap().getStat("DEFENSE");
        double initialDamage = event.getDamage().getDamage();
        if (defense > 0.0 && initialDamage > 0.0) {
            double ratio = Math.max(0.0, new DefenseFormula(false).getAppliedDamage(defense, initialDamage)) / initialDamage;
            event.getDamage().multiplicativeModifier(ratio);
        }
    }

    private static LivingEntity getDamager(EntityDamageByEntityEvent event) {
        Projectile proj;
        if (event.getDamager() instanceof LivingEntity) {
            return (LivingEntity)event.getDamager();
        }
        if (event.getDamager() instanceof Projectile && (proj = (Projectile)event.getDamager()).getShooter() instanceof LivingEntity) {
            return (LivingEntity)proj.getShooter();
        }
        return null;
    }

    public static enum SpecificDamageReductionType {
        ENVIRONMENTAL("DAMAGE_REDUCTION", event -> true),
        PVP(event -> event instanceof EntityDamageByEntityEvent && DamageReduction.getDamager((EntityDamageByEntityEvent)event) instanceof Player),
        PVE(event -> event instanceof EntityDamageByEntityEvent && !(DamageReduction.getDamager((EntityDamageByEntityEvent)event) instanceof Player)),
        FIRE(event -> FIRE_DAMAGE_CAUSES.contains(event.getCause())),
        FALL(event -> event.getCause() == EntityDamageEvent.DamageCause.FALL);

        @NotNull
        private final String stat;
        @NotNull
        private final Predicate<EntityDamageEvent> apply;

        private SpecificDamageReductionType(String stat, Predicate<EntityDamageEvent> apply) {
            this.stat = stat;
            this.apply = Objects.requireNonNull(apply);
        }

        private SpecificDamageReductionType(Predicate<EntityDamageEvent> apply) {
            this.stat = this.name() + "_DAMAGE_REDUCTION";
            this.apply = Objects.requireNonNull(apply);
        }

        public void applyReduction(StatMap statMap, DamageMetadata damageMeta, EntityDamageEvent event) {
            if (this.apply.test(event)) {
                damageMeta.multiplicativeModifier(1.0 - statMap.getStat(this.stat) / 100.0);
            }
        }
    }
}

