/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.listener;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.event.AttackEvent;
import io.lumine.mythic.lib.api.event.mitigation.PlayerBlockEvent;
import io.lumine.mythic.lib.api.event.mitigation.PlayerDodgeEvent;
import io.lumine.mythic.lib.api.event.mitigation.PlayerParryEvent;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.player.cooldown.CooldownType;
import io.lumine.mythic.lib.version.VersionSound;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class MitigationMechanics
implements Listener {
    private static final Random RANDOM = new Random();
    private static final List<EntityDamageEvent.DamageCause> MITIGATION_CAUSES = Arrays.asList(EntityDamageEvent.DamageCause.PROJECTILE, EntityDamageEvent.DamageCause.ENTITY_ATTACK, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK);
    private boolean dodgeKnockbackEnabled;
    private boolean parryKnockbackEnabled;
    private boolean actionBarMessage;
    private double dodgeKnockbackForce;
    private double maxDodgeRating;
    private double maxParryRating;
    private double maxBlockRating;
    private double maxBlockPower;
    private double defaultBlockPower;
    private double parryKnockbackForce;
    private double parryDefaultCooldown;
    private double blockDefaultCooldown;
    private double dodgeDefaultCooldown;
    private double parryMinCooldown;
    private double blockMinCooldown;
    private double dodgeMinCooldown;
    private String parryMessage;
    private String blockMessage;
    private String dodgeMessage;

    public MitigationMechanics() {
        this.reload();
    }

    public void reload() {
        this.dodgeKnockbackEnabled = MythicLib.plugin.getConfig().getBoolean("mitigation.dodge.knockback.enabled");
        this.dodgeKnockbackForce = MythicLib.plugin.getConfig().getDouble("mitigation.dodge.knockback.force");
        this.maxDodgeRating = MythicLib.plugin.getConfig().getDouble("mitigation.dodge.rating-max");
        this.maxParryRating = MythicLib.plugin.getConfig().getDouble("mitigation.parry.rating-max");
        this.maxBlockRating = MythicLib.plugin.getConfig().getDouble("mitigation.block.rating-max");
        this.maxBlockPower = MythicLib.plugin.getConfig().getDouble("mitigation.block.power.max");
        this.defaultBlockPower = MythicLib.plugin.getConfig().getDouble("mitigation.block.power.default");
        this.parryDefaultCooldown = MythicLib.plugin.getConfig().getDouble("mitigation.parry.cooldown.base");
        this.blockDefaultCooldown = MythicLib.plugin.getConfig().getDouble("mitigation.block.cooldown.base");
        this.dodgeDefaultCooldown = MythicLib.plugin.getConfig().getDouble("mitigation.dodge.cooldown.base");
        this.parryMinCooldown = MythicLib.plugin.getConfig().getDouble("mitigation.parry.cooldown.min");
        this.blockMinCooldown = MythicLib.plugin.getConfig().getDouble("mitigation.block.cooldown.min");
        this.dodgeMinCooldown = MythicLib.plugin.getConfig().getDouble("mitigation.dodge.cooldown.min");
        this.parryKnockbackEnabled = MythicLib.plugin.getConfig().getBoolean("mitigation.parry.knockback.enabled");
        this.parryKnockbackForce = MythicLib.plugin.getConfig().getDouble("mitigation.parry.knockback.force");
        this.parryMessage = MythicLib.plugin.getConfig().getString("mitigation.message.parry");
        this.dodgeMessage = MythicLib.plugin.getConfig().getString("mitigation.message.dodge");
        this.blockMessage = MythicLib.plugin.getConfig().getString("mitigation.message.block");
        this.actionBarMessage = MythicLib.plugin.getConfig().getBoolean("mitigation.message.action-bar");
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void a(AttackEvent event) {
        if (!(event.getEntity() instanceof Player) || !MITIGATION_CAUSES.contains(event.toBukkit().getCause()) || event.getEntity().hasMetadata("NPC")) {
            return;
        }
        Player player = (Player)event.getEntity();
        MMOPlayerData playerData = MMOPlayerData.get((OfflinePlayer)player);
        StatMap stats = playerData.getStatMap();
        double dodgeRating = Math.min(stats.getStat("DODGE_RATING"), this.maxDodgeRating) / 100.0;
        if (RANDOM.nextDouble() < dodgeRating && !playerData.isOnCooldown(CooldownType.DODGE)) {
            PlayerDodgeEvent mitigationEvent = new PlayerDodgeEvent(playerData, event.toBukkit());
            Bukkit.getPluginManager().callEvent((Event)mitigationEvent);
            if (mitigationEvent.isCancelled()) {
                return;
            }
            this.sendMessage(player, this.dodgeMessage, "damage", MythicLib.plugin.getMMOConfig().decimal.format(event.getDamage().getDamage()));
            playerData.applyCooldown(CooldownType.DODGE, this.calculateCooldown(this.dodgeDefaultCooldown, stats.getStat("DODGE_COOLDOWN_REDUCTION") / 100.0, this.dodgeMinCooldown));
            event.setCancelled(true);
            player.setNoDamageTicks(10);
            player.getWorld().playSound(player.getLocation(), VersionSound.ENTITY_ENDER_DRAGON_FLAP.toSound(), 2.0f, 1.0f);
            player.getWorld().spawnParticle(Particle.EXPLOSION_NORMAL, player.getLocation(), 16, 0.0, 0.0, 0.0, 0.06);
            if (this.dodgeKnockbackEnabled) {
                player.setVelocity(this.getVector((LivingEntity)player, event).multiply(-0.85 * this.dodgeKnockbackForce).setY(0.3));
            }
            return;
        }
        double parryRating = Math.min(stats.getStat("PARRY_RATING"), this.maxParryRating) / 100.0;
        if (RANDOM.nextDouble() < parryRating && !playerData.isOnCooldown(CooldownType.PARRY)) {
            PlayerParryEvent mitigationEvent = new PlayerParryEvent(playerData, event.toBukkit());
            Bukkit.getPluginManager().callEvent((Event)mitigationEvent);
            if (mitigationEvent.isCancelled()) {
                return;
            }
            playerData.applyCooldown(CooldownType.PARRY, this.calculateCooldown(this.parryDefaultCooldown, stats.getStat("PARRY_COOLDOWN_REDUCTION") / 100.0, this.parryMinCooldown));
            event.setCancelled(true);
            player.setNoDamageTicks(10);
            this.sendMessage(player, this.parryMessage, "damage", MythicLib.plugin.getMMOConfig().decimal.format(event.getDamage().getDamage()));
            player.getWorld().playSound(player.getLocation(), VersionSound.ENTITY_ENDER_DRAGON_FLAP.toSound(), 2.0f, 1.0f);
            player.getWorld().spawnParticle(Particle.EXPLOSION_NORMAL, player.getLocation(), 16, 0.0, 0.0, 0.0, 0.06);
            if (this.parryKnockbackEnabled && event.toBukkit() instanceof EntityDamageByEntityEvent && ((EntityDamageByEntityEvent)event.toBukkit()).getDamager() instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)((EntityDamageByEntityEvent)event.toBukkit()).getDamager();
                attacker.setVelocity(this.normalize(attacker.getLocation().toVector().subtract(player.getLocation().toVector())).setY(0.35).multiply(this.parryKnockbackForce));
            }
            return;
        }
        double blockRating = Math.min(stats.getStat("BLOCK_RATING"), this.maxBlockRating) / 100.0;
        if (RANDOM.nextDouble() < blockRating && !playerData.isOnCooldown(CooldownType.BLOCK)) {
            double blockPower = Math.min(this.defaultBlockPower + stats.getStat("BLOCK_POWER"), this.maxBlockPower) / 100.0;
            PlayerBlockEvent mitigationEvent = new PlayerBlockEvent(playerData, event.toBukkit(), blockPower);
            Bukkit.getPluginManager().callEvent((Event)mitigationEvent);
            if (mitigationEvent.isCancelled()) {
                return;
            }
            playerData.applyCooldown(CooldownType.BLOCK, this.calculateCooldown(this.blockDefaultCooldown, stats.getStat("BLOCK_COOLDOWN_REDUCTION") / 100.0, this.blockMinCooldown));
            this.sendMessage(player, this.blockMessage, "damage", MythicLib.plugin.getMMOConfig().decimal.format(mitigationEvent.getDamageBlocked()), "power", MythicLib.plugin.getMMOConfig().decimal.format(mitigationEvent.getPower() * 100.0));
            event.getDamage().multiplicativeModifier(1.0 - mitigationEvent.getPower());
            player.getWorld().playSound(player.getLocation(), VersionSound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR.toSound(), 2.0f, 1.0f);
            double yaw = this.getYaw((Entity)player, this.getVector((LivingEntity)player, event)) + 90.0;
            for (double j = yaw - 90.0; j < yaw + 90.0; j += 5.0) {
                for (double y = 0.0; y < 2.0; y += 0.1) {
                    player.getWorld().spawnParticle(Particle.REDSTONE, player.getLocation().clone().add(Math.cos(Math.toRadians(j)) * 0.7, y, Math.sin(Math.toRadians(j)) * 0.7), 1, (Object)new Particle.DustOptions(Color.GRAY, 1.0f));
                }
            }
        }
    }

    private void sendMessage(Player player, String format, Object ... placeholders) {
        if (format == null || format.isEmpty()) {
            return;
        }
        format = ChatColor.translateAlternateColorCodes((char)'&', (String)format);
        for (int i = 0; i < placeholders.length; i += 2) {
            format = format.replace("#" + placeholders[i].toString() + "#", placeholders[i + 1].toString());
        }
        if (this.actionBarMessage) {
            MythicLib.plugin.getVersion().getWrapper().sendActionBar(player, format);
        } else {
            player.sendMessage(format);
        }
    }

    private double calculateCooldown(double cooldown, double reduction, double min) {
        return Math.max(min, cooldown * (1.0 - reduction));
    }

    @NotNull
    private Vector getVector(LivingEntity victim, AttackEvent event) {
        Entity damager = event.toBukkit() instanceof EntityDamageByEntityEvent ? ((EntityDamageByEntityEvent)event.toBukkit()).getDamager() : null;
        return damager == null ? this.normalize(damager.getLocation().subtract(victim.getLocation()).toVector()) : victim.getEyeLocation().getDirection();
    }

    @NotNull
    private Vector normalize(Vector vec) {
        return vec.lengthSquared() == 0.0 ? vec : vec.normalize();
    }

    private double getYaw(Entity player, Vector vec) {
        return new Location(player.getWorld(), vec.getX(), vec.getY(), vec.getZ()).setDirection(vec).getYaw();
    }
}

