/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.listener;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.event.PlayerAttackEvent;
import io.lumine.mythic.lib.api.event.PlayerKillEntityEvent;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.comp.interaction.InteractionType;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import io.lumine.mythic.lib.util.CustomProjectile;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class SkillTriggers
implements Listener {
    public SkillTriggers() {
        Bukkit.getScheduler().runTaskTimer((Plugin)MythicLib.plugin, () -> MMOPlayerData.forEachOnline(online -> online.getPassiveSkillMap().tickTimerSkills()), 0L, 1L);
    }

    @EventHandler
    public void killEntity(PlayerKillEntityEvent event) {
        event.getData().triggerSkills(TriggerType.KILL_ENTITY, (Entity)event.getTarget());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void attack(PlayerAttackEvent event) {
        event.getAttacker().getData().triggerSkills(TriggerType.ATTACK, event.getAttacker(), (Entity)event.getEntity());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void damagedByEntity(EntityDamageByEntityEvent event) {
        MMOPlayerData caster;
        if (event.getDamage() == 0.0) {
            return;
        }
        if (event.getEntity() instanceof Player && (caster = MMOPlayerData.getOrNull(event.getEntity().getUniqueId())) != null && MythicLib.plugin.getEntities().canInteract((Player)event.getEntity(), event.getDamager(), InteractionType.OFFENSE_SKILL)) {
            caster.triggerSkills(TriggerType.DAMAGED_BY_ENTITY, event.getDamager());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void damaged(EntityDamageEvent event) {
        MMOPlayerData caster;
        if (event.getEntity() instanceof Player && (caster = MMOPlayerData.getOrNull(event.getEntity().getUniqueId())) != null) {
            caster.triggerSkills(TriggerType.DAMAGED, null);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void death(PlayerDeathEvent event) {
        MMOPlayerData caster = MMOPlayerData.getOrNull(event.getEntity().getUniqueId());
        if (caster != null && caster.isOnline()) {
            caster.triggerSkills(TriggerType.DEATH, null);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void login(PlayerJoinEvent event) {
        MMOPlayerData.get((OfflinePlayer)event.getPlayer()).triggerSkills(TriggerType.LOGIN, null);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    private void shootBow(EntityShootBowEvent event) {
        MMOPlayerData caster;
        if (event.getEntity() instanceof Player && (caster = MMOPlayerData.getOrNull(event.getEntity().getUniqueId())) != null) {
            EquipmentSlot actionHand = this.getShootHand(((Player)event.getEntity()).getInventory());
            caster.triggerSkills(TriggerType.SHOOT_BOW, actionHand, event.getProjectile());
            new CustomProjectile(caster, CustomProjectile.ProjectileType.ARROW, event.getProjectile(), actionHand);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void shootTrident(ProjectileLaunchEvent event) {
        MMOPlayerData caster;
        if (event.getEntity() instanceof Trident && event.getEntity().getShooter() instanceof Player && (caster = MMOPlayerData.getOrNull(event.getEntity().getUniqueId())) != null) {
            Player shooter = (Player)event.getEntity().getShooter();
            EquipmentSlot actionHand = this.getShootHand(shooter.getInventory());
            caster.triggerSkills(TriggerType.SHOOT_TRIDENT, actionHand, (Entity)event.getEntity());
            new CustomProjectile(caster, CustomProjectile.ProjectileType.TRIDENT, (Entity)event.getEntity(), actionHand);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void sneak(PlayerToggleSneakEvent event) {
        if (event.isSneaking()) {
            MMOPlayerData.get((OfflinePlayer)event.getPlayer()).triggerSkills(TriggerType.SNEAK, null);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void click(PlayerInteractEvent event) {
        if (event.getAction() == Action.PHYSICAL) {
            return;
        }
        MMOPlayerData caster = MMOPlayerData.get((OfflinePlayer)event.getPlayer());
        boolean left = event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK;
        boolean sneaking = event.getPlayer().isSneaking();
        TriggerType type = sneaking ? (left ? TriggerType.SHIFT_LEFT_CLICK : TriggerType.SHIFT_RIGHT_CLICK) : (left ? TriggerType.LEFT_CLICK : TriggerType.RIGHT_CLICK);
        caster.triggerSkills(type, EquipmentSlot.fromBukkit(event.getHand()), null);
    }

    private EquipmentSlot getShootHand(PlayerInventory inv) {
        ItemStack main = inv.getItemInMainHand();
        return main != null && this.isShootable(main.getType()) ? EquipmentSlot.MAIN_HAND : EquipmentSlot.OFF_HAND;
    }

    private boolean isShootable(Material mat) {
        return mat == Material.BOW || mat == Material.CROSSBOW || mat == Material.TRIDENT;
    }
}

