/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.listener.option;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.event.AttackEvent;
import io.lumine.mythic.lib.api.event.IndicatorDisplayEvent;
import io.lumine.mythic.lib.damage.DamageMetadata;
import io.lumine.mythic.lib.damage.DamagePacket;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.element.Element;
import io.lumine.mythic.lib.listener.option.GameIndicators;
import io.lumine.mythic.lib.util.CustomFont;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageIndicators
extends GameIndicators {
    private final String skillIcon;
    private final String weaponIcon;
    private final String skillIconCrit;
    private final String weaponIconCrit;
    private final boolean splitHolograms;
    @Nullable
    private final CustomFont font;
    @Nullable
    private final CustomFont fontCrit;

    public DamageIndicators(ConfigurationSection config) {
        super(config);
        this.skillIcon = config.getString("icon.skill.normal");
        this.weaponIcon = config.getString("icon.weapon.normal");
        this.skillIconCrit = config.getString("icon.skill.crit");
        this.weaponIconCrit = config.getString("icon.weapon.crit");
        this.splitHolograms = config.getBoolean("split-holograms");
        if (config.getBoolean("custom-font.enabled")) {
            this.font = new CustomFont(config.getConfigurationSection("custom-font.normal"));
            this.fontCrit = new CustomFont(config.getConfigurationSection("custom-font.crit"));
        } else {
            this.font = null;
            this.fontCrit = null;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void a(AttackEvent event) {
        LivingEntity entity = event.getEntity();
        if (event.getDamage().getDamage() < 0.02) {
            return;
        }
        if (entity instanceof Player && UtilityMethods.isVanished((Player)entity)) {
            return;
        }
        ArrayList holos = new ArrayList();
        Map<IndicatorType, Double> mappedDamage = this.mapDamage(event.getDamage());
        double modifierDue = (event.toBukkit().getFinalDamage() - event.toBukkit().getDamage()) / (double)Math.max(1, mappedDamage.size());
        mappedDamage.forEach((type, val) -> holos.add(((IndicatorType)type).computeFormat(val + modifierDue)));
        if (this.splitHolograms) {
            for (String holo : holos) {
                this.displayIndicator((Entity)entity, holo, this.getDirection(event.toBukkit()), IndicatorDisplayEvent.IndicatorType.DAMAGE);
            }
        } else {
            String joined = String.join((CharSequence)" ", holos);
            this.displayIndicator((Entity)entity, joined, this.getDirection(event.toBukkit()), IndicatorDisplayEvent.IndicatorType.DAMAGE);
        }
    }

    @NotNull
    private Vector getDirection(EntityDamageEvent event) {
        Vector dir2;
        if (event instanceof EntityDamageByEntityEvent && (dir2 = event.getEntity().getLocation().toVector().subtract(((EntityDamageByEntityEvent)event).getDamager().getLocation().toVector()).setY(0)).lengthSquared() > 0.0) {
            double a = Math.atan2(dir2.getZ(), dir2.getX());
            return new Vector(Math.cos(a += 1.5707963267948966 * (random.nextDouble() - 0.5)), 0.0, Math.sin(a));
        }
        double a = random.nextDouble() * Math.PI * 2.0;
        return new Vector(Math.cos(a), 0.0, Math.sin(a));
    }

    @NotNull
    private Map<IndicatorType, Double> mapDamage(DamageMetadata damageMetadata) {
        HashMap<IndicatorType, Double> mapped = new HashMap<IndicatorType, Double>();
        for (DamagePacket packet : damageMetadata.getPackets()) {
            IndicatorType type = new IndicatorType(this, damageMetadata, packet);
            mapped.put(type, mapped.getOrDefault(type, 0.0) + packet.getFinalValue());
        }
        return mapped;
    }

    /*
     * Exception performing whole class analysis.
     */
    private class IndicatorType {
        final boolean physical;
        @Nullable
        final Element element;
        final boolean crit;
        final /* synthetic */ DamageIndicators this$0;

        /*
         * Unable to fully structure code
         */
        IndicatorType(DamageIndicators var1_1, DamageMetadata damageMetadata, DamagePacket packet) {
            this.this$0 = var1_1;
            super();
            this.physical = packet.hasType(DamageType.PHYSICAL);
            this.element = packet.getElement();
            if (this.physical == false ? damageMetadata.isSkillCriticalStrike() != false : damageMetadata.isWeaponCriticalStrike() != false) ** GOTO lbl-1000
            if (this.element != null && damageMetadata.isElementalCriticalStrike(this.element)) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            this.crit = v0;
        }

        @NotNull
        private String computeIcon() {
            StringBuilder build = new StringBuilder();
            if (this.physical) {
                build.append(this.crit ? this.this$0.weaponIconCrit : this.this$0.weaponIcon);
            } else {
                build.append(this.crit ? this.this$0.skillIconCrit : this.this$0.skillIcon);
            }
            if (this.element != null) {
                build.append(this.element.getColor() + this.element.getLoreIcon());
            }
            return build.toString();
        }

        @NotNull
        private String computeFormat(double damage) {
            @Nullable CustomFont indicatorFont = this.crit && this.this$0.fontCrit != null ? this.this$0.fontCrit : this.this$0.font;
            @NotNull String formattedDamage = indicatorFont == null ? this.this$0.formatNumber(damage) : indicatorFont.format(this.this$0.formatNumber(damage));
            return MythicLib.plugin.getPlaceholderParser().parse(null, this.this$0.getRaw().replace("{icon}", this.computeIcon()).replace("{value}", formattedDamage));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndicatorType that = (IndicatorType)o;
            return this.physical == that.physical && Objects.equals(this.element, that.element);
        }

        public int hashCode() {
            return Objects.hash(this.physical, this.element);
        }
    }
}

