/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.listener.option;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.event.IndicatorDisplayEvent;
import io.lumine.mythic.lib.listener.option.GameIndicators;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.util.Vector;

public class RegenIndicators
extends GameIndicators {
    public RegenIndicators(ConfigurationSection config) {
        super(config);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void a(EntityRegainHealthEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity) || event.getAmount() <= 0.0 || ((LivingEntity)entity).getHealth() >= ((LivingEntity)entity).getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()) {
            return;
        }
        if (entity instanceof Player && UtilityMethods.isVanished((Player)entity)) {
            return;
        }
        this.displayIndicator(entity, this.getRaw().replace("#", this.formatNumber(event.getAmount())), this.getIndicatorDirection(entity), IndicatorDisplayEvent.IndicatorType.REGENERATION);
    }

    private Vector getIndicatorDirection(Entity entity) {
        if (entity instanceof Player) {
            double a = Math.toRadians(((Player)entity).getEyeLocation().getYaw()) + Math.PI * (1.0 + (random.nextDouble() - 0.5) / 2.0);
            return new Vector(Math.cos(a), 0.0, Math.sin(a));
        }
        double a = random.nextDouble() * Math.PI * 2.0;
        return new Vector(Math.cos(a), 0.0, Math.sin(a));
    }
}

