/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.manager;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.script.Script;
import io.lumine.mythic.lib.script.condition.Condition;
import io.lumine.mythic.lib.script.condition.generic.BooleanCondition;
import io.lumine.mythic.lib.script.condition.generic.CompareCondition;
import io.lumine.mythic.lib.script.condition.generic.InBetweenCondition;
import io.lumine.mythic.lib.script.condition.generic.StringEqualsCondition;
import io.lumine.mythic.lib.script.condition.location.BiomeCondition;
import io.lumine.mythic.lib.script.condition.location.CuboidCondition;
import io.lumine.mythic.lib.script.condition.location.DistanceCondition;
import io.lumine.mythic.lib.script.condition.location.WorldCondition;
import io.lumine.mythic.lib.script.condition.misc.CanTargetCondition;
import io.lumine.mythic.lib.script.condition.misc.CooldownCondition;
import io.lumine.mythic.lib.script.condition.misc.FoodCondition;
import io.lumine.mythic.lib.script.condition.misc.HasDamageTypeCondition;
import io.lumine.mythic.lib.script.condition.misc.IsLivingCondition;
import io.lumine.mythic.lib.script.condition.misc.OnFireCondition;
import io.lumine.mythic.lib.script.condition.misc.PermissionCondition;
import io.lumine.mythic.lib.script.condition.misc.TimeCondition;
import io.lumine.mythic.lib.script.mechanic.Mechanic;
import io.lumine.mythic.lib.script.mechanic.buff.FeedMechanic;
import io.lumine.mythic.lib.script.mechanic.buff.HealMechanic;
import io.lumine.mythic.lib.script.mechanic.buff.ReduceCooldownMechanic;
import io.lumine.mythic.lib.script.mechanic.buff.SaturateMechanic;
import io.lumine.mythic.lib.script.mechanic.buff.stat.AddStatModifierMechanic;
import io.lumine.mythic.lib.script.mechanic.buff.stat.RemoveStatModifierMechanic;
import io.lumine.mythic.lib.script.mechanic.misc.DelayMechanic;
import io.lumine.mythic.lib.script.mechanic.misc.DispatchCommandMechanic;
import io.lumine.mythic.lib.script.mechanic.misc.EntityEffectMechanic;
import io.lumine.mythic.lib.script.mechanic.misc.LightningStrikeMechanic;
import io.lumine.mythic.lib.script.mechanic.misc.ScriptMechanic;
import io.lumine.mythic.lib.script.mechanic.movement.TeleportMechanic;
import io.lumine.mythic.lib.script.mechanic.movement.VelocityMechanic;
import io.lumine.mythic.lib.script.mechanic.offense.AdditiveDamageBuffMechanic;
import io.lumine.mythic.lib.script.mechanic.offense.DamageMechanic;
import io.lumine.mythic.lib.script.mechanic.offense.MultiplyDamageMechanic;
import io.lumine.mythic.lib.script.mechanic.offense.PotionMechanic;
import io.lumine.mythic.lib.script.mechanic.offense.SetOnFireMechanic;
import io.lumine.mythic.lib.script.mechanic.player.GiveItemMechanic;
import io.lumine.mythic.lib.script.mechanic.player.SudoMechanic;
import io.lumine.mythic.lib.script.mechanic.raytrace.RayTraceAnyMechanic;
import io.lumine.mythic.lib.script.mechanic.raytrace.RayTraceBlocksMechanic;
import io.lumine.mythic.lib.script.mechanic.raytrace.RayTraceEntitiesMechanic;
import io.lumine.mythic.lib.script.mechanic.shaped.HelixMechanic;
import io.lumine.mythic.lib.script.mechanic.shaped.ParabolaMechanic;
import io.lumine.mythic.lib.script.mechanic.shaped.ProjectileMechanic;
import io.lumine.mythic.lib.script.mechanic.shaped.SlashMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.SetDoubleMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.SetIntegerMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.SetStringMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.SetVectorMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.AddVectorMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.CrossProductMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.DotProductMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.HadamardProductMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.MultiplyVectorMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.NormalizeVectorMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.SaveVectorMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.SetXMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.SetYMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.SetZMechanic;
import io.lumine.mythic.lib.script.mechanic.variable.vector.SubtractVectorMechanic;
import io.lumine.mythic.lib.script.mechanic.visual.ParticleMechanic;
import io.lumine.mythic.lib.script.mechanic.visual.SoundMechanic;
import io.lumine.mythic.lib.script.mechanic.visual.TellMechanic;
import io.lumine.mythic.lib.script.targeter.EntityTargeter;
import io.lumine.mythic.lib.script.targeter.LocationTargeter;
import io.lumine.mythic.lib.script.targeter.entity.CasterTargeter;
import io.lumine.mythic.lib.script.targeter.entity.ConeTargeter;
import io.lumine.mythic.lib.script.targeter.entity.NearbyEntitiesTargeter;
import io.lumine.mythic.lib.script.targeter.entity.NearestEntityTargeter;
import io.lumine.mythic.lib.script.targeter.entity.TargetTargeter;
import io.lumine.mythic.lib.script.targeter.entity.VariableEntityTargeter;
import io.lumine.mythic.lib.script.targeter.location.CasterLocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.CircleLocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.CustomLocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.LookingAtTargeter;
import io.lumine.mythic.lib.script.targeter.location.SourceLocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.TargetEntityLocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.TargetLocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.VariableLocationTargeter;
import io.lumine.mythic.lib.skill.handler.MythicLibSkillHandler;
import io.lumine.mythic.lib.skill.handler.MythicMobsSkillHandler;
import io.lumine.mythic.lib.skill.handler.SkillAPISkillHandler;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.util.RecursiveFolderExplorer;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class SkillManager {
    private final Map<String, Function<ConfigObject, Mechanic>> mechanics = new HashMap<String, Function<ConfigObject, Mechanic>>();
    private final Map<String, Function<ConfigObject, Condition>> conditions = new HashMap<String, Function<ConfigObject, Condition>>();
    private final Map<String, Function<ConfigObject, EntityTargeter>> entityTargets = new HashMap<String, Function<ConfigObject, EntityTargeter>>();
    private final Map<String, Function<ConfigObject, LocationTargeter>> locationTargets = new HashMap<String, Function<ConfigObject, LocationTargeter>>();
    private final Map<String, Script> scripts = new HashMap<String, Script>();
    private final Map<String, SkillHandler> handlers = new HashMap<String, SkillHandler>();
    private final Map<Predicate<ConfigurationSection>, Function<ConfigurationSection, SkillHandler>> skillHandlerTypes = new HashMap<Predicate<ConfigurationSection>, Function<ConfigurationSection, SkillHandler>>();
    private boolean registration = true;

    public SkillManager() {
        this.registerMechanic("add_stat", config -> new AddStatModifierMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("remove_stat", config -> new RemoveStatModifierMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("feed", config -> new FeedMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("heal", config -> new HealMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("reduce_cooldown", config -> new ReduceCooldownMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("saturate", config -> new SaturateMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("delay", DelayMechanic::new, new String[0]);
        this.registerMechanic("dispatch_command", DispatchCommandMechanic::new, new String[0]);
        this.registerMechanic("entity_effect", EntityEffectMechanic::new, new String[0]);
        this.registerMechanic("lightning", config -> new LightningStrikeMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("script", config -> new ScriptMechanic((ConfigObject)config), "skill");
        this.registerMechanic("teleport", config -> new TeleportMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("set_velocity", config -> new VelocityMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("additive_damage_buff", config -> new AdditiveDamageBuffMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("damage", config -> new DamageMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("multiply_damage", config -> new MultiplyDamageMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("potion", config -> new PotionMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("set_on_fire", config -> new SetOnFireMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("give_item", config -> new GiveItemMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("sudo", config -> new SudoMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("raytrace", config -> new RayTraceAnyMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("raytrace_blocks", config -> new RayTraceBlocksMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("raytrace_entities", config -> new RayTraceEntitiesMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("helix", config -> new HelixMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("parabola", ParabolaMechanic::new, new String[0]);
        this.registerMechanic("projectile", config -> new ProjectileMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("slash", config -> new SlashMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("add_vector", config -> new AddVectorMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("cross_product", config -> new CrossProductMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("dot_product", config -> new DotProductMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("hadamard_product", config -> new HadamardProductMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("multiply_vector", config -> new MultiplyVectorMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("normalize_vector", config -> new NormalizeVectorMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("save_vector", config -> new SaveVectorMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("set_x", config -> new SetXMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("set_y", config -> new SetYMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("set_z", config -> new SetZMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("subtract_vector", config -> new SubtractVectorMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("set_double", config -> new SetDoubleMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("set_integer", config -> new SetIntegerMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("set_string", config -> new SetStringMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("set_vector", config -> new SetVectorMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("particle", config -> new ParticleMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("sound", config -> new SoundMechanic((ConfigObject)config), new String[0]);
        this.registerMechanic("tell", config -> new TellMechanic((ConfigObject)config), new String[0]);
        this.registerEntityTargeter("caster", config -> new CasterTargeter());
        this.registerEntityTargeter("cone", config -> new ConeTargeter((ConfigObject)config));
        this.registerEntityTargeter("nearby_entities", config -> new NearbyEntitiesTargeter((ConfigObject)config));
        this.registerEntityTargeter("nearest_entity", config -> new NearestEntityTargeter((ConfigObject)config));
        this.registerEntityTargeter("target", config -> new TargetTargeter());
        this.registerEntityTargeter("variable", config -> new VariableEntityTargeter((ConfigObject)config));
        this.registerLocationTargeter("caster", config -> new CasterLocationTargeter((ConfigObject)config));
        this.registerLocationTargeter("circle", config -> new CircleLocationTargeter((ConfigObject)config));
        this.registerLocationTargeter("custom", config -> new CustomLocationTargeter((ConfigObject)config));
        this.registerLocationTargeter("looking_at", config -> new LookingAtTargeter((ConfigObject)config));
        this.registerLocationTargeter("source_location", config -> new SourceLocationTargeter());
        this.registerLocationTargeter("target", config -> new TargetEntityLocationTargeter((ConfigObject)config));
        this.registerLocationTargeter("target_location", config -> new TargetLocationTargeter());
        this.registerLocationTargeter("variable", config -> new VariableLocationTargeter((ConfigObject)config));
        this.registerCondition("boolean", config -> new BooleanCondition((ConfigObject)config));
        this.registerCondition("compare", config -> new CompareCondition((ConfigObject)config));
        this.registerCondition("in_between", config -> new InBetweenCondition((ConfigObject)config));
        this.registerCondition("string_equals", config -> new StringEqualsCondition((ConfigObject)config));
        this.registerCondition("biome", config -> new BiomeCondition((ConfigObject)config));
        this.registerCondition("cuboid", config -> new CuboidCondition((ConfigObject)config));
        this.registerCondition("distance", config -> new DistanceCondition((ConfigObject)config));
        this.registerCondition("world", config -> new WorldCondition((ConfigObject)config));
        this.registerCondition("can_target", config -> new CanTargetCondition((ConfigObject)config));
        this.registerCondition("cooldown", config -> new CooldownCondition((ConfigObject)config));
        this.registerCondition("food", config -> new FoodCondition((ConfigObject)config));
        this.registerCondition("has_damage_type", config -> new HasDamageTypeCondition((ConfigObject)config));
        this.registerCondition("is_living", config -> new IsLivingCondition((ConfigObject)config));
        this.registerCondition("on_fire", config -> new OnFireCondition((ConfigObject)config));
        this.registerCondition("permission", config -> new PermissionCondition((ConfigObject)config));
        this.registerCondition("time", config -> new TimeCondition((ConfigObject)config));
        this.registerSkillHandlerType(config -> config.contains("mythiclib-skill-id"), config -> new MythicLibSkillHandler(this.getScriptOrThrow(config.getString("mythiclib-skill-id"))));
        this.registerSkillHandlerType(config -> config.contains("mechanics"), config -> new MythicLibSkillHandler(new Script((ConfigurationSection)config)));
    }

    public void registerSkillHandlerType(Predicate<ConfigurationSection> matcher, Function<ConfigurationSection, SkillHandler> provider) {
        Validate.notNull(matcher);
        Validate.notNull(provider);
        this.skillHandlerTypes.put(matcher, provider);
    }

    @NotNull
    public SkillHandler<?> loadSkillHandler(Object obj) throws IllegalArgumentException, IllegalStateException {
        if (obj instanceof String) {
            return this.getHandlerOrThrow(obj.toString());
        }
        if (obj instanceof ConfigurationSection) {
            ConfigurationSection config = (ConfigurationSection)obj;
            for (Map.Entry<Predicate<ConfigurationSection>, Function<ConfigurationSection, SkillHandler>> type : this.skillHandlerTypes.entrySet()) {
                if (!type.getKey().test(config)) continue;
                return type.getValue().apply(config);
            }
            throw new IllegalArgumentException("Could not match handler type to config");
        }
        throw new IllegalArgumentException("Provide either a string or configuration section instead of " + obj.getClass().getSimpleName());
    }

    public void registerSkillHandler(SkillHandler<?> handler) {
        Validate.isTrue((!this.handlers.containsKey(handler.getId()) ? 1 : 0) != 0, (String)"A skill handler with the same name already exists");
        this.handlers.put(handler.getId(), handler);
        if (!this.registration && handler instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)handler, (Plugin)MythicLib.plugin);
        }
    }

    @NotNull
    public SkillHandler<?> getHandlerOrThrow(String id) {
        return Objects.requireNonNull(this.handlers.get(id), "Could not find handler with ID '" + id + "'");
    }

    public Collection<SkillHandler> getHandlers() {
        return this.handlers.values();
    }

    public void registerScript(@NotNull Script script) {
        Validate.isTrue((!this.scripts.containsKey(script.getId()) ? 1 : 0) != 0, (String)"A script with the same name already exists");
        this.scripts.put(script.getId(), script);
    }

    @NotNull
    public Script getScriptOrThrow(String name) {
        return Objects.requireNonNull(this.scripts.get(name), "Could not find script with name '" + name + "'");
    }

    public Script loadScript(Object obj) {
        if (obj instanceof String) {
            return this.getScriptOrThrow(obj.toString());
        }
        if (obj instanceof ConfigurationSection) {
            Script skill = new Script((ConfigurationSection)obj);
            skill.postLoad();
            return skill;
        }
        throw new IllegalArgumentException("Provide either a string or configuration section");
    }

    public Collection<Script> getScripts() {
        return this.scripts.values();
    }

    public void registerCondition(String name, Function<ConfigObject, Condition> condition) {
        Validate.isTrue((boolean)this.registration, (String)"Condition registration is disabled");
        Validate.isTrue((!this.conditions.containsKey(name) ? 1 : 0) != 0, (String)"A condition with the same name already exists");
        Validate.notNull(condition, (String)"Function cannot be null");
        this.conditions.put(name, condition);
    }

    @NotNull
    public Condition loadCondition(ConfigObject config) {
        Validate.isTrue((boolean)config.contains("type"), (String)"Cannot find condition type");
        String key = config.getString("type");
        Function<ConfigObject, Condition> supplier = this.conditions.get(key);
        if (supplier != null) {
            return supplier.apply(config);
        }
        throw new IllegalArgumentException("Could not match condition to '" + key + "'");
    }

    public void registerMechanic(String name, Function<ConfigObject, Mechanic> mechanic, String ... aliases) {
        Validate.isTrue((boolean)this.registration, (String)"Mechanic registration is disabled");
        Validate.isTrue((!this.mechanics.containsKey(name) ? 1 : 0) != 0, (String)"A mechanic with the same name already exists");
        Validate.notNull(mechanic, (String)"Function cannot be null");
        this.mechanics.put(name, mechanic);
        for (String alias : aliases) {
            this.registerMechanic(alias, mechanic, new String[0]);
        }
    }

    @NotNull
    public Mechanic loadMechanic(ConfigObject config) {
        Validate.isTrue((boolean)config.contains("type"), (String)"Cannot find mechanic type");
        String key = config.getString("type");
        Function<ConfigObject, Mechanic> supplier = this.mechanics.get(key);
        if (supplier != null) {
            return supplier.apply(config);
        }
        throw new IllegalArgumentException("Could not match mechanic to '" + key + "'");
    }

    public void registerEntityTargeter(String name, Function<ConfigObject, EntityTargeter> entityTarget) {
        Validate.isTrue((boolean)this.registration, (String)"Targeter registration is disabled");
        Validate.isTrue((!this.entityTargets.containsKey(name) ? 1 : 0) != 0, (String)"A targeter with the same name already exists");
        Validate.notNull(entityTarget, (String)"Function cannot be null");
        this.entityTargets.put(name, entityTarget);
    }

    @NotNull
    public EntityTargeter loadEntityTargeter(ConfigObject config) {
        Validate.isTrue((boolean)config.contains("type"), (String)"Cannot find targeter type");
        String key = config.getString("type");
        Function<ConfigObject, EntityTargeter> supplier = this.entityTargets.get(key);
        if (supplier != null) {
            return supplier.apply(config);
        }
        throw new IllegalArgumentException("Could not match targeter to '" + key + "'");
    }

    public void registerLocationTargeter(String name, Function<ConfigObject, LocationTargeter> locationTarget) {
        Validate.isTrue((boolean)this.registration, (String)"Targeter registration is disabled");
        Validate.isTrue((!this.locationTargets.containsKey(name) ? 1 : 0) != 0, (String)"A targeter with the same name already exists");
        Validate.notNull(locationTarget, (String)"Function cannot be null");
        this.locationTargets.put(name, locationTarget);
    }

    @NotNull
    public LocationTargeter loadLocationTargeter(ConfigObject config) {
        Validate.isTrue((boolean)config.contains("type"), (String)"Cannot find targeter type");
        String key = config.getString("type");
        Function<ConfigObject, LocationTargeter> supplier = this.locationTargets.get(key);
        if (supplier != null) {
            return supplier.apply(config);
        }
        throw new IllegalArgumentException("Could not match targeter to '" + key + "'");
    }

    public void initialize(boolean clearBefore) {
        if (clearBefore) {
            for (SkillHandler handler : this.handlers.values()) {
                if (!(handler instanceof Listener)) continue;
                HandlerList.unregisterAll((Listener)((Listener)handler));
            }
            this.handlers.clear();
            this.scripts.clear();
        } else {
            File scriptFolder;
            this.registration = false;
            File skillsFolder = new File(MythicLib.plugin.getDataFolder() + "/skill");
            if (!skillsFolder.exists()) {
                skillsFolder.mkdir();
            }
            if (!(scriptFolder = new File(MythicLib.plugin.getDataFolder() + "/script")).exists()) {
                UtilityMethods.loadDefaultFile("script", "element-attacks.yml");
                UtilityMethods.loadDefaultFile("script", "showcase-skills.yml");
            }
            if (Bukkit.getPluginManager().getPlugin("MythicMobs") != null) {
                this.registerSkillHandlerType(config -> config.contains("mythicmobs-skill-id"), config -> new MythicMobsSkillHandler((ConfigurationSection)config));
            }
            if (Bukkit.getPluginManager().getPlugin("SkillAPI") != null || Bukkit.getPluginManager().getPlugin("ProSkillAPI") != null) {
                this.registerSkillHandlerType(config -> config.contains("skillapi-skill-id"), config -> new SkillAPISkillHandler((ConfigurationSection)config));
            }
        }
        try {
            JarFile file2 = new JarFile(MythicLib.plugin.getJarFile());
            Enumeration<JarEntry> enu = file2.entries();
            while (enu.hasMoreElements()) {
                String name = enu.nextElement().getName().replace("/", ".");
                if (name.contains("$") || !name.endsWith(".class") || !name.startsWith("io.lumine.mythic.lib.skill.handler.def.")) continue;
                SkillHandler ability = (SkillHandler)Class.forName(name.substring(0, name.length() - 6)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.registerSkillHandler(ability);
                if (!(ability instanceof Listener)) continue;
                Bukkit.getPluginManager().registerEvents((Listener)ability, (Plugin)MythicLib.plugin);
            }
            file2.close();
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
        new RecursiveFolderExplorer(file -> {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            for (String key : config.getKeys(false)) {
                try {
                    this.registerScript(new Script(Objects.requireNonNull(config.getConfigurationSection(key), "Config is null")));
                }
                catch (RuntimeException exception) {
                    MythicLib.plugin.getLogger().log(Level.WARNING, "Could not initialize script '" + key + "' from '" + file.getName() + "': " + exception.getMessage());
                }
            }
        }, (Plugin)MythicLib.plugin, "Could not load scripts").explore(new File(MythicLib.plugin.getDataFolder() + "/script"));
        for (Script script : this.scripts.values()) {
            try {
                script.postLoad();
                if (!script.isPublic()) continue;
                this.registerSkillHandler(new MythicLibSkillHandler(script));
            }
            catch (RuntimeException exception) {
                MythicLib.plugin.getLogger().log(Level.WARNING, "Could not load script '" + script.getId() + "': " + exception.getMessage());
            }
        }
        new RecursiveFolderExplorer(file -> {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            if (config.contains("modifiers")) {
                try {
                    this.registerSkillHandler(this.loadSkillHandler(YamlConfiguration.loadConfiguration((File)file)));
                }
                catch (RuntimeException exception) {
                    MythicLib.plugin.getLogger().log(Level.WARNING, "Could not load skill handler '" + file.getName() + "': " + exception.getMessage());
                }
            } else {
                for (String key : config.getKeys(false)) {
                    try {
                        this.registerSkillHandler(this.loadSkillHandler(config.getConfigurationSection(key)));
                    }
                    catch (RuntimeException exception) {
                        MythicLib.plugin.getLogger().log(Level.WARNING, "Could not load skill handler '" + key + "' from file '" + file.getName() + "': " + exception.getMessage());
                    }
                }
            }
        }, (Plugin)MythicLib.plugin, "Could not load skills").explore(new File(MythicLib.plugin.getDataFolder() + "/skill"));
    }
}

