/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.manager;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.handler.AttributeStatHandler;
import io.lumine.mythic.lib.api.stat.handler.MovementSpeedStatHandler;
import io.lumine.mythic.lib.api.stat.handler.StatHandler;
import io.lumine.mythic.lib.util.ConfigFile;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatManager {
    private final Map<String, StatHandler> handlers = new HashMap<String, StatHandler>();
    private final Map<String, DecimalFormat> decimalFormats = new HashMap<String, DecimalFormat>();
    private DecimalFormat defaultDecimalFormat;

    public StatManager() {
        this.handlers.put("ARMOR", new AttributeStatHandler(Attribute.GENERIC_ARMOR, "ARMOR"));
        this.handlers.put("ARMOR_TOUGHNESS", new AttributeStatHandler(Attribute.GENERIC_ARMOR_TOUGHNESS, "ARMOR_TOUGHNESS"));
        this.handlers.put("ATTACK_DAMAGE", new AttributeStatHandler(Attribute.GENERIC_ATTACK_DAMAGE, "ATTACK_DAMAGE", true));
        this.handlers.put("ATTACK_SPEED", new AttributeStatHandler(Attribute.GENERIC_ATTACK_SPEED, "ATTACK_SPEED", true));
        this.handlers.put("KNOCKBACK_RESISTANCE", new AttributeStatHandler(Attribute.GENERIC_KNOCKBACK_RESISTANCE, "KNOCKBACK_RESISTANCE"));
        this.handlers.put("MAX_HEALTH", new AttributeStatHandler(Attribute.GENERIC_MAX_HEALTH, "MAX_HEALTH"));
        this.handlers.put("MOVEMENT_SPEED", new MovementSpeedStatHandler(true));
        this.handlers.put("SPEED_MALUS_REDUCTION", new MovementSpeedStatHandler(false));
    }

    public void initialize(boolean clearBefore) {
        if (clearBefore) {
            this.decimalFormats.clear();
        } else {
            UtilityMethods.loadDefaultFile("", "stats.yml");
        }
        this.defaultDecimalFormat = MythicLib.plugin.getMMOConfig().newDecimalFormat("0.#");
        FileConfiguration config = new ConfigFile("stats").getConfig();
        for (String key : config.getConfigurationSection("decimal-format").getKeys(false)) {
            try {
                String stat = UtilityMethods.enumName(key);
                this.decimalFormats.put(stat, MythicLib.plugin.getMMOConfig().newDecimalFormat(config.getString("decimal-format." + key)));
            }
            catch (RuntimeException exception) {
                MythicLib.plugin.getLogger().log(Level.WARNING, "Could not load decimal format of '" + key + "': " + exception.getMessage());
            }
        }
    }

    @NotNull
    public static String format(String stat, MMOPlayerData player) {
        StatManager manager = MythicLib.plugin.getStats();
        double value = MythicLib.plugin.getStats().getTotalValue(stat, player.getStatMap());
        return Objects.requireNonNullElse(manager.decimalFormats.get(stat), manager.defaultDecimalFormat).format(value);
    }

    @NotNull
    public static String format(String stat, double value) {
        StatManager manager = MythicLib.plugin.getStats();
        return Objects.requireNonNullElse(manager.decimalFormats.get(stat), manager.defaultDecimalFormat).format(value);
    }

    public void runUpdates(StatMap map) {
        this.handlers.values().forEach(update -> update.runUpdate(map));
    }

    public void runUpdate(StatMap map, String stat) {
        StatHandler handler = this.handlers.get(stat);
        if (handler != null) {
            handler.runUpdate(map);
        }
    }

    public double getBaseValue(String stat, StatMap map) {
        @Nullable StatHandler handler = this.handlers.get(stat);
        return handler == null ? 0.0 : handler.getBaseValue(map);
    }

    public double getTotalValue(String stat, StatMap map) {
        @Nullable StatHandler handler = this.handlers.get(stat);
        return handler == null ? map.getStat(stat) : handler.getTotalValue(map);
    }

    public void registerStat(String stat, StatHandler handler) {
        Validate.notNull((Object)stat, (String)"Stat cannot be null");
        Validate.notNull((Object)handler, (String)"StatHandler cannot be null");
        this.handlers.put(stat, handler);
    }

    @Nullable
    public StatHandler getStatHandler(String id) {
        return this.handlers.get(id);
    }

    public boolean isRegistered(String stat) {
        return this.handlers.containsKey(stat);
    }

    public Set<String> getRegisteredStats() {
        return this.handlers.keySet();
    }

    public void clearRegisteredStats(Predicate<StatHandler> filter) {
        Iterator<StatHandler> ite = this.handlers.values().iterator();
        while (ite.hasNext()) {
            if (!filter.test(ite.next())) continue;
            ite.remove();
        }
    }
}

