/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.math3.fitting.leastsquares;

import io.lumine.mythic.lib.math3.fitting.leastsquares.AbstractEvaluation;
import io.lumine.mythic.lib.math3.fitting.leastsquares.LeastSquaresProblem;
import io.lumine.mythic.lib.math3.linear.RealMatrix;
import io.lumine.mythic.lib.math3.linear.RealVector;

class DenseWeightedEvaluation
extends AbstractEvaluation {
    private final LeastSquaresProblem.Evaluation unweighted;
    private final RealMatrix weightSqrt;

    DenseWeightedEvaluation(LeastSquaresProblem.Evaluation unweighted, RealMatrix weightSqrt) {
        super(weightSqrt.getColumnDimension());
        this.unweighted = unweighted;
        this.weightSqrt = weightSqrt;
    }

    public RealMatrix getJacobian() {
        return this.weightSqrt.multiply(this.unweighted.getJacobian());
    }

    public RealVector getResiduals() {
        return this.weightSqrt.operate(this.unweighted.getResiduals());
    }

    public RealVector getPoint() {
        return this.unweighted.getPoint();
    }
}

