/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.parser.client;

import io.lumine.mythic.lib.parser.client.Scanner;
import io.lumine.mythic.lib.parser.client.SyntaxError;
import io.lumine.mythic.lib.parser.client.ast.ASTNode;
import io.lumine.mythic.lib.parser.client.ast.FunctionNode;
import io.lumine.mythic.lib.parser.client.ast.IParserFactory;
import io.lumine.mythic.lib.parser.client.ast.IntegerNode;
import io.lumine.mythic.lib.parser.client.ast.NumberNode;
import io.lumine.mythic.lib.parser.client.ast.PatternNode;
import io.lumine.mythic.lib.parser.client.ast.SymbolNode;
import io.lumine.mythic.lib.parser.client.operator.ASTNodeFactory;
import io.lumine.mythic.lib.parser.client.operator.InfixOperator;
import io.lumine.mythic.lib.parser.client.operator.Operator;
import io.lumine.mythic.lib.parser.client.operator.PostfixOperator;
import io.lumine.mythic.lib.parser.client.operator.PrefixOperator;
import java.util.ArrayList;
import java.util.List;

public class Parser
extends Scanner {
    private final boolean fRelaxedSyntax;
    private List<ASTNode> fNodeList = null;
    public static final SymbolNode DERIVATIVE = new SymbolNode("Derivative");

    public Parser() {
        this(ASTNodeFactory.MMA_STYLE_FACTORY, false, false);
    }

    public Parser(boolean relaxedSyntax) throws SyntaxError {
        this(ASTNodeFactory.MMA_STYLE_FACTORY, relaxedSyntax);
    }

    public Parser(boolean relaxedSyntax, boolean packageMode) throws SyntaxError {
        this(ASTNodeFactory.MMA_STYLE_FACTORY, relaxedSyntax, packageMode);
    }

    public Parser(IParserFactory factory, boolean relaxedSyntax) throws SyntaxError {
        this(factory, relaxedSyntax, false);
    }

    public Parser(IParserFactory factory, boolean relaxedSyntax, boolean packageMode) throws SyntaxError {
        super(packageMode);
        this.fRelaxedSyntax = relaxedSyntax;
        this.fFactory = factory;
        if (packageMode) {
            this.fNodeList = new ArrayList<ASTNode>(256);
        }
    }

    public void setFactory(IParserFactory factory) {
        this.fFactory = factory;
    }

    public IParserFactory getFactory() {
        return this.fFactory;
    }

    private void getArguments(FunctionNode function) throws SyntaxError {
        while (true) {
            function.add(this.parseOperators(this.parsePrimary(), 0));
            if (this.fToken != 134) break;
            this.getNextToken();
        }
    }

    private PrefixOperator determinePrefixOperator() {
        Operator oper = null;
        for (int i = 0; i < this.fOperList.size(); ++i) {
            oper = (Operator)this.fOperList.get(i);
            if (!(oper instanceof PrefixOperator)) continue;
            return (PrefixOperator)oper;
        }
        return null;
    }

    private PostfixOperator determinePostfixOperator() {
        Operator oper = null;
        for (int i = 0; i < this.fOperList.size(); ++i) {
            oper = (Operator)this.fOperList.get(i);
            if (!(oper instanceof PostfixOperator)) continue;
            return (PostfixOperator)oper;
        }
        return null;
    }

    private InfixOperator determineBinaryOperator() {
        Operator oper = null;
        for (int i = 0; i < this.fOperList.size(); ++i) {
            oper = (Operator)this.fOperList.get(i);
            if (!(oper instanceof InfixOperator)) continue;
            return (InfixOperator)oper;
        }
        return null;
    }

    private ASTNode parseArguments(ASTNode lhs) {
        if (this.fRelaxedSyntax) {
            if (this.fToken == 12) {
                lhs = this.getFunctionArguments(lhs);
            } else if (this.fToken == 14) {
                lhs = this.getFunction(lhs);
            }
        } else if (this.fToken == 12) {
            lhs = this.getFunctionArguments(lhs);
        }
        return lhs;
    }

    private ASTNode parsePrimary() {
        if (this.fToken == 31) {
            if (";;".equals(this.fOperatorString)) {
                FunctionNode function = this.fFactory.createFunction(this.fFactory.createSymbol("Span"));
                function.add(this.fFactory.createInteger(1));
                function.add(this.fFactory.createSymbol("All"));
                this.getNextToken();
                return function;
            }
            if (this.fOperatorString.equals(".")) {
                this.fCurrentChar = (char)46;
                return this.getNumber(false);
            }
            PrefixOperator prefixOperator = this.determinePrefixOperator();
            if (prefixOperator != null) {
                this.getNextToken();
                ASTNode temp = this.parseLookaheadOperator(prefixOperator.getPrecedence());
                if ("PreMinus".equals(prefixOperator.getFunctionName()) && temp instanceof NumberNode) {
                    ((NumberNode)temp).toggleSign();
                    return temp;
                }
                return prefixOperator.createFunction(this.fFactory, temp);
            }
            this.throwSyntaxError("Operator: " + this.fOperatorString + " is no prefix operator.");
        }
        return this.getPart();
    }

    private ASTNode parseLookaheadOperator(int min_precedence) {
        ASTNode rhs = this.parsePrimary();
        while (true) {
            int lookahead = this.fToken;
            if (this.fToken == 150) {
                return rhs;
            }
            if (this.fToken == 16 || this.fToken == 14 || this.fToken == 138 || this.fToken == 136 || this.fToken == 139 || this.fToken == 141) {
                InfixOperator timesOperator = (InfixOperator)this.fFactory.get("Times");
                if (timesOperator.getPrecedence() > min_precedence) {
                    rhs = this.parseOperators(rhs, timesOperator.getPrecedence());
                    continue;
                }
                if (timesOperator.getPrecedence() != min_precedence || timesOperator.getGrouping() != 1) break;
                rhs = this.parseOperators(rhs, timesOperator.getPrecedence());
                continue;
            }
            if (lookahead != 31) break;
            InfixOperator infixOperator = this.determineBinaryOperator();
            if (infixOperator != null) {
                if (infixOperator.getPrecedence() <= min_precedence && (infixOperator.getPrecedence() != min_precedence || infixOperator.getGrouping() != 1)) break;
                if (infixOperator.getOperatorString().equals(";") && this.fPackageMode && this.fRecursionDepth < 1) {
                    return infixOperator.createFunction(this.fFactory, rhs, this.fFactory.createSymbol("Null"));
                }
                rhs = this.parseOperators(rhs, infixOperator.getPrecedence());
                continue;
            }
            PostfixOperator postfixOperator = this.determinePostfixOperator();
            if (postfixOperator == null || postfixOperator.getPrecedence() < min_precedence) break;
            this.getNextToken();
            rhs = postfixOperator.createFunction(this.fFactory, rhs);
        }
        return rhs;
    }

    private ASTNode parseCompoundExpressionNull(InfixOperator infixOperator, ASTNode rhs) {
        if (infixOperator.getOperatorString().equals(";")) {
            if (this.fToken == 13 || this.fToken == 17 || this.fToken == 15) {
                return infixOperator.createFunction(this.fFactory, rhs, this.fFactory.createSymbol("Null"));
            }
            if (this.fPackageMode && this.fRecursionDepth < 1) {
                return infixOperator.createFunction(this.fFactory, rhs, this.fFactory.createSymbol("Null"));
            }
        }
        return null;
    }

    private ASTNode parseOperators(ASTNode lhs, int min_precedence) {
        block15: {
            ASTNode rhs = null;
            while (true) {
                if (this.fToken == 150) {
                    return lhs;
                }
                if (this.fToken == 16 || this.fToken == 14 || this.fToken == 138 || this.fToken == 136 || this.fToken == 139 || this.fToken == 141 || this.fToken == 142) {
                    Operator oper = this.fFactory.get("Times");
                    if (oper.getPrecedence() >= min_precedence) {
                        rhs = this.parseLookaheadOperator(oper.getPrecedence());
                        lhs = this.fFactory.createFunction(this.fFactory.createSymbol(oper.getFunctionName()), lhs, rhs);
                        continue;
                    }
                } else if (this.fToken != 31) {
                    if (this.fToken == 146) {
                        int derivativeCounter = 1;
                        this.getNextToken();
                        while (this.fToken == 146) {
                            ++derivativeCounter;
                            this.getNextToken();
                        }
                        FunctionNode head = this.fFactory.createFunction(DERIVATIVE, new IntegerNode(derivativeCounter));
                        FunctionNode deriv = this.fFactory.createAST(head);
                        deriv.add(lhs);
                        lhs = this.parseArguments(deriv);
                        continue;
                    }
                } else {
                    InfixOperator infixOperator = this.determineBinaryOperator();
                    if (infixOperator != null) {
                        if (infixOperator.getPrecedence() >= min_precedence) {
                            this.getNextToken();
                            ASTNode compoundExpressionNull = this.parseCompoundExpressionNull(infixOperator, lhs);
                            if (compoundExpressionNull != null) {
                                return compoundExpressionNull;
                            }
                            while (this.fToken == 150) {
                                this.getNextToken();
                            }
                            rhs = this.parseLookaheadOperator(infixOperator.getPrecedence());
                            lhs = infixOperator.createFunction(this.fFactory, lhs, rhs);
                            continue;
                        }
                    } else {
                        PostfixOperator postfixOperator = this.determinePostfixOperator();
                        if (postfixOperator == null) break;
                        if (postfixOperator.getPrecedence() >= min_precedence) {
                            this.getNextToken();
                            lhs = postfixOperator.createFunction(this.fFactory, lhs);
                            lhs = this.parseArguments(lhs);
                            continue;
                        }
                    }
                }
                break block15;
                break;
            }
            this.throwSyntaxError("Operator: " + this.fOperatorString + " is no infix or postfix operator.");
        }
        return lhs;
    }

    public ASTNode parse(String expression) throws SyntaxError {
        this.initialize(expression);
        ASTNode temp = this.parseOperators(this.parsePrimary(), 0);
        if (this.fToken != 0) {
            if (this.fToken == 15) {
                this.throwSyntaxError("Too many closing ')'; End-of-file not reached.");
            }
            if (this.fToken == 17) {
                this.throwSyntaxError("Too many closing '}'; End-of-file not reached.");
            }
            if (this.fToken == 13) {
                this.throwSyntaxError("Too many closing ']'; End-of-file not reached.");
            }
            this.throwSyntaxError("End-of-file not reached.");
        }
        return temp;
    }

    public List<ASTNode> parsePackage(String expression) throws SyntaxError {
        this.initialize(expression);
        while (this.fToken == 150) {
            this.getNextToken();
        }
        ASTNode temp = this.parseOperators(this.parsePrimary(), 0);
        this.fNodeList.add(temp);
        while (this.fToken != 0) {
            if (this.fToken == 15) {
                this.throwSyntaxError("Too many closing ')'; End-of-file not reached.");
            }
            if (this.fToken == 17) {
                this.throwSyntaxError("Too many closing '}'; End-of-file not reached.");
            }
            if (this.fToken == 13) {
                this.throwSyntaxError("Too many closing ']'; End-of-file not reached.");
            }
            while (this.fToken == 150) {
                this.getNextToken();
            }
            if (this.fToken == 0) {
                return this.fNodeList;
            }
            temp = this.parseOperators(this.parsePrimary(), 0);
            this.fNodeList.add(temp);
        }
        return this.fNodeList;
    }

    private ASTNode getNumber(boolean negative) throws SyntaxError {
        ASTNode temp = null;
        Object[] result = this.getNumberString();
        String number = (String)result[0];
        int numFormat = (Integer)result[1];
        try {
            if (negative) {
                number = '-' + number;
            }
            temp = numFormat < 0 ? this.fFactory.createDouble(number) : this.fFactory.createInteger(number, numFormat);
        }
        catch (Exception e) {
            this.throwSyntaxError("Number format error: " + number, number.length());
        }
        this.getNextToken();
        return temp;
    }

    private int getIntegerNumber() throws SyntaxError {
        Object[] result = this.getNumberString();
        String number = (String)result[0];
        int numFormat = (Integer)result[1];
        int intValue = 0;
        try {
            intValue = Integer.parseInt(number, numFormat);
        }
        catch (NumberFormatException e) {
            this.throwSyntaxError("Number format error (not an int type): " + number, number.length());
        }
        this.getNextToken();
        return intValue;
    }

    private SymbolNode getSymbol() throws SyntaxError {
        String identifier = this.getIdentifier();
        if (!this.fFactory.isValidIdentifier(identifier)) {
            this.throwSyntaxError("Invalid identifier: " + identifier + " detected.");
        }
        SymbolNode symbol = this.fFactory.createSymbol(identifier);
        this.getNextToken();
        return symbol;
    }

    private ASTNode getString() throws SyntaxError {
        StringBuilder ident = this.getStringBuffer();
        this.getNextToken();
        return this.fFactory.createString(ident);
    }

    private ASTNode getList() throws SyntaxError {
        FunctionNode function = this.fFactory.createFunction(this.fFactory.createSymbol("List"));
        this.getNextToken();
        if (this.fToken == 17) {
            this.getNextToken();
            return function;
        }
        ++this.fRecursionDepth;
        try {
            this.getArguments(function);
        }
        finally {
            --this.fRecursionDepth;
        }
        if (this.fToken == 17) {
            this.getNextToken();
            return function;
        }
        this.throwSyntaxError("'}' expected.");
        return null;
    }

    FunctionNode getFunction(ASTNode head) throws SyntaxError {
        FunctionNode function = this.fFactory.createAST(head);
        this.getNextToken();
        if (this.fRelaxedSyntax) {
            if (this.fToken == 15) {
                this.getNextToken();
                if (this.fToken == 14) {
                    return function;
                }
                if (this.fToken == 12) {
                    return this.getFunctionArguments(function);
                }
                return function;
            }
        } else if (this.fToken == 13) {
            this.getNextToken();
            if (this.fToken == 12) {
                return this.getFunctionArguments(function);
            }
            return function;
        }
        ++this.fRecursionDepth;
        try {
            this.getArguments(function);
        }
        finally {
            --this.fRecursionDepth;
        }
        if (this.fRelaxedSyntax) {
            if (this.fToken == 15) {
                this.getNextToken();
                if (this.fToken == 14) {
                    return function;
                }
                if (this.fToken == 12) {
                    return this.getFunctionArguments(function);
                }
                return function;
            }
        } else if (this.fToken == 13) {
            this.getNextToken();
            if (this.fToken == 12) {
                return this.getFunctionArguments(function);
            }
            return function;
        }
        if (this.fRelaxedSyntax) {
            this.throwSyntaxError("')' expected.");
        } else {
            this.throwSyntaxError("']' expected.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionNode getFunctionArguments(ASTNode head) throws SyntaxError {
        FunctionNode function = this.fFactory.createAST(head);
        ++this.fRecursionDepth;
        try {
            this.getNextToken();
            if (this.fToken == 13) {
                this.getNextToken();
                if (this.fToken == 12) {
                    FunctionNode functionNode = this.getFunctionArguments(function);
                    return functionNode;
                }
                FunctionNode functionNode = function;
                return functionNode;
            }
            this.getArguments(function);
        }
        finally {
            --this.fRecursionDepth;
        }
        if (this.fToken == 13) {
            this.getNextToken();
            if (this.fToken == 12) {
                return this.getFunctionArguments(function);
            }
            return function;
        }
        this.throwSyntaxError("']' expected.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ASTNode getFactor() throws SyntaxError {
        if (this.fToken == 138) {
            ASTNode temp;
            SymbolNode symbol = this.getSymbol();
            if (this.fToken == 137) {
                if (this.isWhitespace()) {
                    temp = this.fFactory.createPattern(symbol, null);
                    this.getNextToken();
                } else {
                    this.getNextToken();
                    if (this.fToken == 138) {
                        SymbolNode check = this.getSymbol();
                        temp = this.fFactory.createPattern(symbol, check);
                    } else {
                        temp = this.fFactory.createPattern(symbol, null);
                    }
                }
            } else if (this.fToken == 143) {
                if (this.isWhitespace()) {
                    temp = this.fFactory.createPattern2(symbol, null);
                    this.getNextToken();
                } else {
                    this.getNextToken();
                    if (this.fToken == 138) {
                        SymbolNode check = this.getSymbol();
                        temp = this.fFactory.createPattern2(symbol, check);
                    } else {
                        temp = this.fFactory.createPattern2(symbol, null);
                    }
                }
            } else if (this.fToken == 144) {
                if (this.isWhitespace()) {
                    temp = this.fFactory.createPattern3(symbol, null);
                    this.getNextToken();
                } else {
                    this.getNextToken();
                    if (this.fToken == 138) {
                        SymbolNode check = this.getSymbol();
                        temp = this.fFactory.createPattern3(symbol, check);
                    } else {
                        temp = this.fFactory.createPattern3(symbol, null);
                    }
                }
            } else if (this.fToken == 145) {
                if (this.isWhitespace()) {
                    temp = this.fFactory.createPattern(symbol, null, true);
                    this.getNextToken();
                } else {
                    this.getNextToken();
                    if (this.fToken == 138) {
                        SymbolNode check = this.getSymbol();
                        temp = this.fFactory.createPattern(symbol, check, true);
                    } else {
                        temp = this.fFactory.createPattern(symbol, null, true);
                    }
                }
            } else {
                temp = symbol;
            }
            return this.parseArguments(temp);
        }
        if (this.fToken == 137) {
            PatternNode temp;
            if (this.isWhitespace()) {
                this.getNextToken();
                temp = this.fFactory.createPattern(null, null);
            } else {
                this.getNextToken();
                if (this.fToken == 138) {
                    SymbolNode check = this.getSymbol();
                    temp = this.fFactory.createPattern(null, check);
                } else {
                    temp = this.fFactory.createPattern(null, null);
                }
            }
            return this.parseArguments(temp);
        }
        if (this.fToken == 143) {
            PatternNode temp;
            if (this.isWhitespace()) {
                this.getNextToken();
                temp = this.fFactory.createPattern2(null, null);
            } else {
                this.getNextToken();
                if (this.fToken == 138) {
                    SymbolNode check = this.getSymbol();
                    temp = this.fFactory.createPattern2(null, check);
                } else {
                    temp = this.fFactory.createPattern2(null, null);
                }
            }
            return this.parseArguments(temp);
        }
        if (this.fToken == 144) {
            PatternNode temp;
            if (this.isWhitespace()) {
                this.getNextToken();
                temp = this.fFactory.createPattern3(null, null);
            } else {
                this.getNextToken();
                if (this.fToken == 138) {
                    SymbolNode check = this.getSymbol();
                    temp = this.fFactory.createPattern3(null, check);
                } else {
                    temp = this.fFactory.createPattern3(null, null);
                }
            }
            return this.parseArguments(temp);
        }
        if (this.fToken == 145) {
            PatternNode temp;
            if (this.isWhitespace()) {
                this.getNextToken();
                temp = this.fFactory.createPattern(null, null, true);
            } else {
                this.getNextToken();
                if (this.fToken == 138) {
                    SymbolNode check = this.getSymbol();
                    temp = this.fFactory.createPattern(null, check, true);
                } else {
                    temp = this.fFactory.createPattern(null, null, true);
                }
            }
            return this.parseArguments(temp);
        }
        if (this.fToken == 139) {
            return this.getNumber(false);
        }
        if (this.fToken == 14) {
            ASTNode temp;
            ++this.fRecursionDepth;
            try {
                this.getNextToken();
                temp = this.parseOperators(this.parsePrimary(), 0);
                if (this.fToken != 15) {
                    this.throwSyntaxError("')' expected.");
                }
            }
            finally {
                --this.fRecursionDepth;
            }
            this.getNextToken();
            if (this.fToken == 14) {
                return this.getTimes(temp);
            }
            if (this.fToken == 12) {
                return this.getFunctionArguments(temp);
            }
            return temp;
        }
        if (this.fToken == 16) {
            return this.getList();
        }
        if (this.fToken == 136) {
            return this.getString();
        }
        if (this.fToken == 135) {
            FunctionNode out = this.fFactory.createFunction(this.fFactory.createSymbol("Out"));
            int countPercent = 1;
            this.getNextToken();
            if (this.fToken == 139) {
                countPercent = this.getIntegerNumber();
                out.add(this.fFactory.createInteger(countPercent));
                return out;
            }
            while (this.fToken == 135) {
                ++countPercent;
                this.getNextToken();
            }
            out.add(this.fFactory.createInteger(-countPercent));
            return this.parseArguments(out);
        }
        if (this.fToken == 141) {
            this.getNextToken();
            FunctionNode slot = this.fFactory.createFunction(this.fFactory.createSymbol("Slot"));
            if (this.fToken == 139) {
                slot.add(this.getNumber(false));
            } else {
                slot.add(this.fFactory.createInteger(1));
            }
            return this.parseArguments(slot);
        }
        if (this.fToken == 142) {
            this.getNextToken();
            FunctionNode slotSequencce = this.fFactory.createFunction(this.fFactory.createSymbol("SlotSequence"));
            if (this.fToken == 139) {
                slotSequencce.add(this.getNumber(false));
            } else {
                slotSequencce.add(this.fFactory.createInteger(1));
            }
            return this.parseArguments(slotSequencce);
        }
        switch (this.fToken) {
            case 15: {
                this.throwSyntaxError("Too much closing ) in factor.");
                break;
            }
            case 17: {
                this.throwSyntaxError("Too much closing } in factor.");
                break;
            }
            case 13: {
                this.throwSyntaxError("Too much closing ] in factor.");
                break;
            }
            default: {
                this.throwSyntaxError("Error in factor at character: '" + this.fCurrentChar + "' (" + this.fToken + ")");
                return null;
            }
        }
        this.throwSyntaxError("Error in factor at character: '" + this.fCurrentChar + "' (" + this.fToken + ")");
        return null;
    }

    private ASTNode getTimes(ASTNode temp) throws SyntaxError {
        FunctionNode func = this.fFactory.createAST(new SymbolNode("Times"));
        func.add(temp);
        do {
            this.getNextToken();
            temp = this.parseOperators(this.parsePrimary(), 0);
            func.add(temp);
            if (this.fToken != 15) {
                this.throwSyntaxError("')' expected.");
            }
            this.getNextToken();
        } while (this.fToken == 14);
        return func;
    }

    private ASTNode getPart() throws SyntaxError {
        ASTNode temp = this.getFactor();
        if (this.fToken != 18) {
            return temp;
        }
        FunctionNode function = null;
        do {
            function = function == null ? this.fFactory.createFunction(this.fFactory.createSymbol("Part"), temp) : this.fFactory.createFunction(this.fFactory.createSymbol("Part"), function);
            ++this.fRecursionDepth;
            try {
                do {
                    this.getNextToken();
                    if (this.fToken == 13 && this.fInputString.length() > this.fCurrentPosition && this.fInputString.charAt(this.fCurrentPosition) == ']') {
                        this.throwSyntaxError("Statement (i.e. index) expected in [[ ]].");
                    }
                    function.add(this.parseOperators(this.parsePrimary(), 0));
                } while (this.fToken == 134);
                if (this.fToken == 13 && this.fInputString.length() > this.fCurrentPosition && this.fInputString.charAt(this.fCurrentPosition) == ']') {
                    ++this.fCurrentPosition;
                    this.fToken = 19;
                }
                if (this.fToken != 19) {
                    this.throwSyntaxError("']]' expected.");
                }
            }
            finally {
                --this.fRecursionDepth;
            }
            this.getNextToken();
        } while (this.fToken == 18);
        return this.parseArguments(function);
    }
}

