/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.parser.client;

import io.lumine.mythic.lib.math3.exception.MathRuntimeException;
import io.lumine.mythic.lib.math3.exception.util.LocalizedFormats;

public class SyntaxError
extends MathRuntimeException {
    private static final long serialVersionUID = 1849387697719679119L;
    int fStartOffset;
    int fRowIndex;
    int fColumnIndex;
    int fLength;
    String fCurrentLine;
    String fError;

    public SyntaxError(int startOffset, int rowIndx, int columnIndx, String currentLine, String error, int length) {
        super(LocalizedFormats.ILLEGAL_STATE, new Object[0]);
        this.fStartOffset = startOffset;
        this.fRowIndex = rowIndx;
        this.fColumnIndex = columnIndx;
        this.fCurrentLine = currentLine;
        this.fError = error;
        this.fLength = length;
    }

    @Override
    public String getMessage() {
        StringBuffer buf = new StringBuffer(256);
        buf.append("Syntax error in line: ");
        buf.append(this.fRowIndex + 1);
        buf.append(" - " + this.fError + "\n");
        buf.append(this.fCurrentLine + "\n");
        for (int i = 0; i < this.fColumnIndex - 1; ++i) {
            buf.append(' ');
        }
        buf.append('^');
        return buf.toString();
    }

    public int getStartOffset() {
        return this.fStartOffset;
    }

    public int getColumnIndex() {
        return this.fColumnIndex;
    }

    public String getCurrentLine() {
        return this.fCurrentLine;
    }

    public String getError() {
        return this.fError;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getRowIndex() {
        return this.fRowIndex;
    }
}

