/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.parser.client.eval;

import io.lumine.mythic.lib.math3.complex.Complex;
import io.lumine.mythic.lib.math3.util.MathUtils;
import io.lumine.mythic.lib.parser.client.ast.ASTNode;
import io.lumine.mythic.lib.parser.client.eval.ComplexEvaluator;

public class ComplexNode
extends ASTNode {
    private final Complex value;

    public ComplexNode(Complex comp) {
        super("ComplexNode");
        this.value = comp;
    }

    public ComplexNode(double real) {
        super("ComplexNode");
        this.value = new Complex(real, 0.0);
    }

    public ComplexNode(double real, double imag) {
        super("ComplexNode");
        this.value = new Complex(real, imag);
    }

    public Complex complexValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return ComplexEvaluator.toString(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ComplexNode) {
            return this.value == ((ComplexNode)obj).value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long rbits = MathUtils.hash(this.value.getReal());
        long ibits = MathUtils.hash(this.value.getImaginary());
        return (int)(rbits ^ ibits >>> 32);
    }
}

