/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.parser.client.eval.api;

import io.lumine.mythic.lib.math3.FieldElement;
import io.lumine.mythic.lib.parser.client.ast.ASTNode;
import io.lumine.mythic.lib.parser.client.ast.FloatNode;
import io.lumine.mythic.lib.parser.client.ast.FractionNode;
import io.lumine.mythic.lib.parser.client.ast.FunctionNode;
import io.lumine.mythic.lib.parser.client.ast.IntegerNode;
import io.lumine.mythic.lib.parser.client.ast.NumberNode;
import io.lumine.mythic.lib.parser.client.ast.PatternNode;
import io.lumine.mythic.lib.parser.client.ast.StringNode;
import io.lumine.mythic.lib.parser.client.ast.SymbolNode;
import io.lumine.mythic.lib.parser.client.eval.BooleanVariable;
import io.lumine.mythic.lib.parser.client.eval.ComplexNode;
import io.lumine.mythic.lib.parser.client.eval.DoubleNode;
import io.lumine.mythic.lib.parser.client.eval.api.FieldElementVariable;
import io.lumine.mythic.lib.parser.client.eval.api.IASTVisitor;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanBoolean1Function;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanBoolean2Function;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanFieldElement2Function;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanFunction;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElement0Function;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElement1Function;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElement2Function;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElementFunction;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElementFunctionNode;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElementInt2Function;
import io.lumine.mythic.lib.parser.client.math.ArithmeticMathException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractASTVisitor<T extends FieldElement<T>>
implements IASTVisitor<T> {
    protected Map<String, FieldElementVariable<T>> fVariableMap;
    protected Map<String, BooleanVariable> fBooleanVariables;
    protected final boolean fRelaxedSyntax;

    public AbstractASTVisitor(boolean relaxedSyntax) {
        this.fRelaxedSyntax = relaxedSyntax;
        this.fVariableMap = new HashMap<String, FieldElementVariable<T>>();
        this.fBooleanVariables = new HashMap<String, BooleanVariable>();
    }

    public boolean evaluateFunctionLogical(FunctionNode functionNode) {
        if (functionNode.size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            String symbol = functionNode.getNode(0).toString();
            if (functionNode.size() == 2) {
                IBooleanFunction<T> function = this.getFunctionBooleanMap(symbol);
                if (function instanceof IBooleanBoolean1Function) {
                    return ((IBooleanBoolean1Function)function).evaluate(this.evaluateNodeLogical(functionNode.getNode(1)));
                }
            } else if (functionNode.size() == 3) {
                IBooleanFunction<T> function = this.getFunctionBooleanMap(symbol);
                if (function instanceof IBooleanFieldElement2Function) {
                    return ((IBooleanFieldElement2Function)function).evaluate(this.evaluateNode(functionNode.getNode(1)), this.evaluateNode(functionNode.getNode(2)));
                }
                if (function instanceof IBooleanBoolean2Function) {
                    return ((IBooleanBoolean2Function)function).evaluate(this.evaluateNodeLogical(functionNode.getNode(1)), this.evaluateNodeLogical(functionNode.getNode(2)));
                }
            }
        }
        throw new ArithmeticMathException("AbstractASTVisitor#evaluateFunctionLogical(FunctionNode) not possible for: " + functionNode.toString());
    }

    @Override
    public T evaluateNode(ASTNode node) {
        if (node instanceof DoubleNode) {
            return this.visit((DoubleNode)node);
        }
        if (node instanceof ComplexNode) {
            return this.visit((ComplexNode)node);
        }
        if (node instanceof FunctionNode) {
            return this.visit((FunctionNode)node);
        }
        if (node instanceof NumberNode) {
            if (node instanceof FloatNode) {
                return this.visit((FloatNode)node);
            }
            if (node instanceof FractionNode) {
                return this.visit((FractionNode)node);
            }
            if (node instanceof IntegerNode) {
                return this.visit((IntegerNode)node);
            }
        }
        if (node instanceof PatternNode) {
            return this.visit((PatternNode)node);
        }
        if (node instanceof StringNode) {
            return this.visit((StringNode)node);
        }
        if (node instanceof SymbolNode) {
            return this.visit((SymbolNode)node);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T evaluateNode(ASTNode node, T value) {
        try {
            this.setUp(value);
            T t = this.evaluateNode(node);
            return t;
        }
        finally {
            this.tearDown();
        }
    }

    public boolean evaluateNodeLogical(ASTNode node) {
        if (node instanceof FunctionNode) {
            return this.evaluateFunctionLogical((FunctionNode)node);
        }
        if (node instanceof SymbolNode) {
            BooleanVariable v = this.fBooleanVariables.get(node.toString());
            if (v != null) {
                return v.getValue();
            }
            Boolean boole = this.getSymbolBooleanMap(node.toString());
            if (boole != null) {
                return boole;
            }
        }
        throw new ArithmeticMathException("AbstractASTVisitor#evaluateNodeLogical(ASTNode) not possible for: " + node.toString());
    }

    public abstract IBooleanFunction<T> getFunctionBooleanMap(String var1);

    public abstract IFieldElementFunction<T> getFunctionMap(String var1);

    public abstract Boolean getSymbolBooleanMap(String var1);

    public abstract T getSymbolFieldElementMap(String var1);

    public boolean isRelaxedSyntax() {
        return this.fRelaxedSyntax;
    }

    @Override
    public void setUp(T value) {
    }

    @Override
    public void tearDown() {
    }

    @Override
    public T visit(ComplexNode node) {
        return null;
    }

    @Override
    public T visit(DoubleNode node) {
        return null;
    }

    @Override
    public T visit(FloatNode node) {
        return null;
    }

    @Override
    public T visit(FractionNode node) {
        return null;
    }

    @Override
    public T visit(FunctionNode functionNode) {
        if (functionNode.size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            String symbol = functionNode.getNode(0).toString();
            if (symbol.equals("If") || this.fRelaxedSyntax && symbol.equalsIgnoreCase("If")) {
                if (functionNode.size() == 3) {
                    if (this.evaluateNodeLogical(functionNode.getNode(1))) {
                        return this.evaluateNode(functionNode.getNode(2));
                    }
                } else if (functionNode.size() == 4) {
                    if (this.evaluateNodeLogical(functionNode.getNode(1))) {
                        return this.evaluateNode(functionNode.getNode(2));
                    }
                    return this.evaluateNode(functionNode.getNode(3));
                }
            } else {
                IFieldElementFunction<T> function = this.getFunctionMap(symbol);
                if (function instanceof IFieldElementFunctionNode) {
                    return ((IFieldElementFunctionNode)function).evaluate(this, functionNode);
                }
                if (functionNode.size() == 1) {
                    if (function instanceof IFieldElement0Function) {
                        return ((IFieldElement0Function)function).evaluate();
                    }
                } else if (functionNode.size() == 2) {
                    if (function instanceof IFieldElement1Function) {
                        return ((IFieldElement1Function)function).evaluate(this.evaluateNode(functionNode.getNode(1)));
                    }
                } else if (functionNode.size() == 3) {
                    ASTNode arg2 = functionNode.getNode(2);
                    if (function instanceof IFieldElementInt2Function && arg2 instanceof IntegerNode) {
                        return ((IFieldElementInt2Function)function).evaluate(this.evaluateNode(functionNode.getNode(1)), ((IntegerNode)arg2).getIntValue());
                    }
                    if (function instanceof IFieldElement2Function) {
                        return ((IFieldElement2Function)function).evaluate(this.evaluateNode(functionNode.getNode(1)), this.evaluateNode(functionNode.getNode(2)));
                    }
                }
            }
        }
        throw new ArithmeticMathException("AbstractASTVisitor#evaluateFunction(FunctionNode) not possible for: " + functionNode.toString());
    }

    @Override
    public T visit(IntegerNode node) {
        return null;
    }

    @Override
    public T visit(PatternNode node) {
        return null;
    }

    @Override
    public T visit(StringNode node) {
        return null;
    }

    @Override
    public T visit(SymbolNode node) {
        FieldElementVariable<T> v = this.fVariableMap.get(node.toString());
        if (v != null) {
            return v.getValue();
        }
        T c = this.getSymbolFieldElementMap(node.toString());
        if (c != null) {
            return c;
        }
        throw new ArithmeticMathException("ComplexEvalVisitor#visit(SymbolNode) not possible for: " + node.toString());
    }
}

