/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.parser.client.eval.bigfraction;

import io.lumine.mythic.lib.math3.Field;
import io.lumine.mythic.lib.math3.fraction.BigFraction;
import io.lumine.mythic.lib.math3.fraction.BigFractionField;
import io.lumine.mythic.lib.parser.client.Parser;
import io.lumine.mythic.lib.parser.client.SyntaxError;
import io.lumine.mythic.lib.parser.client.ast.ASTNode;
import io.lumine.mythic.lib.parser.client.ast.FloatNode;
import io.lumine.mythic.lib.parser.client.ast.FractionNode;
import io.lumine.mythic.lib.parser.client.ast.FunctionNode;
import io.lumine.mythic.lib.parser.client.ast.IntegerNode;
import io.lumine.mythic.lib.parser.client.ast.NumberNode;
import io.lumine.mythic.lib.parser.client.ast.PatternNode;
import io.lumine.mythic.lib.parser.client.ast.StringNode;
import io.lumine.mythic.lib.parser.client.ast.SymbolNode;
import io.lumine.mythic.lib.parser.client.eval.BooleanVariable;
import io.lumine.mythic.lib.parser.client.eval.ComplexNode;
import io.lumine.mythic.lib.parser.client.eval.DoubleNode;
import io.lumine.mythic.lib.parser.client.eval.api.FieldElementEvaluator;
import io.lumine.mythic.lib.parser.client.eval.api.FieldElementVariable;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanBoolean1Function;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanBoolean2Function;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanFieldElement2Function;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanFunction;
import io.lumine.mythic.lib.parser.client.eval.api.IEvaluator;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElement0Function;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElement1Function;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElement2Function;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElementFunction;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElementFunctionNode;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElementInt2Function;
import io.lumine.mythic.lib.parser.client.eval.api.function.CompoundExpressionFunction;
import io.lumine.mythic.lib.parser.client.eval.api.function.PlusFunction;
import io.lumine.mythic.lib.parser.client.eval.api.function.SetFunction;
import io.lumine.mythic.lib.parser.client.eval.api.function.TimesFunction;
import io.lumine.mythic.lib.parser.client.eval.bigfraction.BigFractionNode;
import io.lumine.mythic.lib.parser.client.eval.bigfraction.BigFractionVariable;
import io.lumine.mythic.lib.parser.client.math.ArithmeticMathException;
import io.lumine.mythic.lib.parser.client.operator.ASTNodeFactory;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BigFractionEvaluator
extends FieldElementEvaluator<BigFraction> {
    private static Map<String, BigFraction> SYMBOL_MAP = new ConcurrentHashMap<String, BigFraction>();
    private static Map<String, Boolean> SYMBOL_BOOLEAN_MAP = new ConcurrentHashMap<String, Boolean>();
    private static Map<String, IFieldElementFunction<BigFraction>> FUNCTION_MAP;
    private static Map<String, IBooleanFunction<BigFraction>> FUNCTION_BOOLEAN_MAP;
    private final BigFractionField fDfpField;
    private final BigFractionNode fZERO;
    private ASTNode fNode;
    private final ASTNodeFactory fASTFactory;

    public static ASTNode parseNode(int decimalDigits, String expression, boolean relaxedSyntax) {
        BigFractionEvaluator dfpEvaluator = new BigFractionEvaluator(relaxedSyntax);
        return dfpEvaluator.parse(expression);
    }

    public BigFractionEvaluator() {
        this(null, false);
    }

    public BigFractionEvaluator(ASTNode node, boolean relaxedSyntax) {
        super(relaxedSyntax);
        this.fASTFactory = new ASTNodeFactory(relaxedSyntax);
        this.fVariableMap = new HashMap();
        this.fBooleanVariables = new HashMap();
        this.fNode = node;
        this.fDfpField = BigFractionField.getInstance();
        this.fZERO = new BigFractionNode(this.fDfpField.getZero());
        this.init();
        if (this.fRelaxedSyntax && SYMBOL_MAP.get("pi") == null) {
            for (String key : SYMBOL_MAP.keySet()) {
                SYMBOL_MAP.put(key.toLowerCase(), SYMBOL_MAP.get(key));
            }
            for (String key : SYMBOL_BOOLEAN_MAP.keySet()) {
                SYMBOL_BOOLEAN_MAP.put(key.toLowerCase(), SYMBOL_BOOLEAN_MAP.get(key));
            }
            for (String key : FUNCTION_MAP.keySet()) {
                FUNCTION_MAP.put(key.toLowerCase(), FUNCTION_MAP.get(key));
            }
            for (String key : FUNCTION_BOOLEAN_MAP.keySet()) {
                FUNCTION_BOOLEAN_MAP.put(key.toLowerCase(), FUNCTION_BOOLEAN_MAP.get(key));
            }
        }
    }

    public BigFractionEvaluator(boolean relaxedSyntax) {
        this(null, relaxedSyntax);
    }

    @Override
    public void clearVariables() {
        this.fVariableMap.clear();
        this.fBooleanVariables.clear();
    }

    @Override
    public FieldElementVariable<BigFraction> createVariable(BigFraction value) {
        return new BigFractionVariable(value);
    }

    public void defineVariable(String variableName) {
        if (this.fRelaxedSyntax) {
            this.fVariableMap.put(variableName.toLowerCase(), new BigFractionVariable(this.fDfpField.getZero()));
        } else {
            this.fVariableMap.put(variableName, new BigFractionVariable(this.fDfpField.getZero()));
        }
    }

    @Override
    public void defineVariable(String variableName, BooleanVariable value) {
        if (this.fRelaxedSyntax) {
            this.fBooleanVariables.put(variableName.toLowerCase(), value);
        } else {
            this.fBooleanVariables.put(variableName, value);
        }
    }

    public void defineVariable(String variableName, BigFraction value) {
        if (this.fRelaxedSyntax) {
            this.fVariableMap.put(variableName.toLowerCase(), new BigFractionVariable(value));
        } else {
            this.fVariableMap.put(variableName, new BigFractionVariable(value));
        }
    }

    @Override
    public void defineVariable(String variableName, FieldElementVariable<BigFraction> value) {
        if (this.fRelaxedSyntax) {
            this.fVariableMap.put(variableName.toLowerCase(), value);
        } else {
            this.fVariableMap.put(variableName, value);
        }
    }

    public ASTNode derivative(ASTNode node, String var) {
        SymbolNode sym = this.fASTFactory.createSymbol(var);
        return this.derivative(node, sym);
    }

    public ASTNode derivative(ASTNode node, SymbolNode var) {
        if (node.isFree(var)) {
            return new BigFractionNode(this.fDfpField.getZero());
        }
        if (node instanceof FunctionNode) {
            FunctionNode f = (FunctionNode)node;
            if (f.size() > 1 && f.getNode(0) instanceof SymbolNode) {
                SymbolNode head = (SymbolNode)f.getNode(0);
                if (f.size() == 2) {
                    ASTNode arg1Derived = this.derivative(f.getNode(1), var);
                    if (this.isSymbol(head, "Exp")) {
                        FunctionNode fun = new FunctionNode(this.fASTFactory.createSymbol("Exp"));
                        fun.add(f.getNode(1));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                    if (this.isSymbol(head, "Cos")) {
                        FunctionNode fun = new FunctionNode(this.fASTFactory.createSymbol("Times"));
                        fun.add(new BigFractionNode(BigFraction.MINUS_ONE));
                        fun.add(new FunctionNode(this.fASTFactory.createSymbol("Cos"), f.getNode(1)));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                    if (this.isSymbol(head, "Sin")) {
                        FunctionNode fun = new FunctionNode(this.fASTFactory.createSymbol("Cos"));
                        fun.add(f.getNode(1));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                } else if (f.size() == 3 && this.isSymbol(head, "Power")) {
                    if (f.get(2).isFree(var)) {
                        ASTNode arg1Derived = this.derivative(f.getNode(1), var);
                        FunctionNode exponent = this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Plus"), new BigFractionNode(BigFraction.MINUS_ONE), f.get(2));
                        FunctionNode fun = this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Times"), f.get(2), this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Power"), f.get(1), exponent));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                    if (f.get(1).isFree(var)) {
                        ASTNode arg2Derived = this.derivative(f.getNode(2), var);
                        FunctionNode fun = this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Times"), this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Log"), f.get(1)), f);
                        return this.getDerivativeResult(arg2Derived, fun);
                    }
                } else {
                    if (this.isSymbol(head, "Plus")) {
                        FunctionNode result = new FunctionNode(f.getNode(0));
                        for (int i = 1; i < f.size(); ++i) {
                            ASTNode deriv = this.derivative(f.getNode(i), var);
                            if (deriv.equals(this.fZERO)) continue;
                            result.add(deriv);
                        }
                        return result;
                    }
                    if (this.isSymbol(head, "Times")) {
                        FunctionNode plusResult = new FunctionNode(this.fASTFactory.createSymbol("Plus"));
                        for (int i = 1; i < f.size(); ++i) {
                            FunctionNode timesResult = new FunctionNode(f.getNode(0));
                            boolean valid = true;
                            for (int j = 1; j < f.size(); ++j) {
                                if (j == i) {
                                    ASTNode deriv = this.derivative(f.getNode(j), var);
                                    if (deriv.equals(this.fZERO)) {
                                        valid = false;
                                        continue;
                                    }
                                    timesResult.add(deriv);
                                    continue;
                                }
                                timesResult.add(f.getNode(j));
                            }
                            if (!valid) continue;
                            plusResult.add(timesResult);
                        }
                        return plusResult;
                    }
                }
            }
            return new FunctionNode(new SymbolNode("D"), node, var);
        }
        if (node instanceof SymbolNode) {
            if (this.isSymbol((SymbolNode)node, var)) {
                return new BigFractionNode(this.fDfpField.getOne());
            }
            FieldElementVariable v = (FieldElementVariable)this.fVariableMap.get(node.toString());
            if (v != null) {
                return new BigFractionNode(this.fDfpField.getZero());
            }
            BigFraction dbl = SYMBOL_MAP.get(node.toString());
            if (dbl != null) {
                return new BigFractionNode(this.fDfpField.getZero());
            }
            return new BigFractionNode(this.fDfpField.getZero());
        }
        if (node instanceof NumberNode) {
            return new BigFractionNode(this.fDfpField.getZero());
        }
        throw new ArithmeticMathException("BigFractionEvaluator#derivative(ASTNode, SymbolNode) not possible for: " + node.toString());
    }

    @Override
    public BigFraction evaluate() {
        if (this.fNode == null) {
            throw new SyntaxError(0, 0, 0, " ", "No parser input defined", 1);
        }
        return this.evaluateNode(this.fNode);
    }

    @Override
    public BigFraction evaluate(String expression) {
        Parser p = this.fRelaxedSyntax ? new Parser(ASTNodeFactory.RELAXED_STYLE_FACTORY, true) : new Parser(ASTNodeFactory.MMA_STYLE_FACTORY, false);
        this.fNode = p.parse(expression);
        if (this.fNode instanceof FunctionNode) {
            this.fNode = this.optimizeFunction((FunctionNode)this.fNode);
        }
        return this.evaluateNode(this.fNode);
    }

    public BigFraction evaluateFunction(FunctionNode functionNode) {
        if (!functionNode.isEmpty() && functionNode.getNode(0) instanceof SymbolNode) {
            String symbol = functionNode.getNode(0).toString();
            if (symbol.equals("If") || this.fRelaxedSyntax && symbol.equalsIgnoreCase("if")) {
                if (functionNode.size() == 3) {
                    if (this.evaluateNodeLogical(functionNode.getNode(1))) {
                        return this.evaluateNode(functionNode.getNode(2));
                    }
                } else if (functionNode.size() == 4) {
                    if (this.evaluateNodeLogical(functionNode.getNode(1))) {
                        return this.evaluateNode(functionNode.getNode(2));
                    }
                    return this.evaluateNode(functionNode.getNode(3));
                }
            } else {
                IFieldElementFunction<BigFraction> function = FUNCTION_MAP.get(symbol);
                if (function instanceof IFieldElementFunctionNode) {
                    return ((IFieldElementFunctionNode)function).evaluate(this, functionNode);
                }
                if (functionNode.size() == 1) {
                    if (function instanceof IFieldElement0Function) {
                        return (BigFraction)((IFieldElement0Function)function).evaluate();
                    }
                } else if (functionNode.size() == 2) {
                    if (function instanceof IFieldElement1Function) {
                        return ((IFieldElement1Function)function).evaluate(this.evaluateNode(functionNode.getNode(1)));
                    }
                } else if (functionNode.size() == 3) {
                    ASTNode arg2 = functionNode.getNode(2);
                    if (function instanceof IFieldElementInt2Function && arg2 instanceof IntegerNode) {
                        return ((IFieldElementInt2Function)function).evaluate(this.evaluateNode(functionNode.getNode(1)), ((IntegerNode)arg2).getIntValue());
                    }
                    if (function instanceof IFieldElement2Function) {
                        return ((IFieldElement2Function)function).evaluate(this.evaluateNode(functionNode.getNode(1)), this.evaluateNode(arg2));
                    }
                }
            }
        }
        throw new ArithmeticMathException("DfpEvaluator#evaluateFunction(FunctionNode) not possible for: " + functionNode.toString());
    }

    @Override
    public boolean evaluateFunctionLogical(FunctionNode functionNode) {
        if (!functionNode.isEmpty() && functionNode.getNode(0) instanceof SymbolNode) {
            String symbol = functionNode.getNode(0).toString();
            if (functionNode.size() == 2) {
                IBooleanFunction<BigFraction> function = FUNCTION_BOOLEAN_MAP.get(symbol);
                if (function instanceof IBooleanBoolean1Function) {
                    return ((IBooleanBoolean1Function)function).evaluate(this.evaluateNodeLogical(functionNode.getNode(1)));
                }
            } else if (functionNode.size() == 3) {
                IBooleanFunction<BigFraction> function = FUNCTION_BOOLEAN_MAP.get(symbol);
                if (function instanceof IBooleanFieldElement2Function) {
                    return ((IBooleanFieldElement2Function)function).evaluate(this.evaluateNode(functionNode.getNode(1)), this.evaluateNode(functionNode.getNode(2)));
                }
                if (function instanceof IBooleanBoolean2Function) {
                    return ((IBooleanBoolean2Function)function).evaluate(this.evaluateNodeLogical(functionNode.getNode(1)), this.evaluateNodeLogical(functionNode.getNode(2)));
                }
            }
        }
        throw new ArithmeticMathException("BigFractionEvaluator#evaluateFunctionLogical(FunctionNode) not possible for: " + functionNode.toString());
    }

    @Override
    public BigFraction evaluateNode(ASTNode node) {
        if (node instanceof BigFractionNode) {
            return ((BigFractionNode)node).getValue();
        }
        if (node instanceof FunctionNode) {
            return this.evaluateFunction((FunctionNode)node);
        }
        if (node instanceof SymbolNode) {
            FieldElementVariable v = (FieldElementVariable)this.fVariableMap.get(node.toString());
            if (v != null) {
                return (BigFraction)v.getValue();
            }
            BigFraction dbl = SYMBOL_MAP.get(node.toString());
            if (dbl != null) {
                return dbl;
            }
        } else if (node instanceof NumberNode) {
            if (node instanceof FractionNode) {
                return new BigFraction(new BigInteger(((FractionNode)node).getNumerator().getString()), new BigInteger(((FractionNode)node).getDenominator().getString()));
            }
            if (node instanceof IntegerNode) {
                String iStr = ((NumberNode)node).getString();
                if (iStr != null) {
                    return new BigFraction(new BigInteger(iStr), BigInteger.ONE);
                }
                return new BigFraction(((IntegerNode)node).getIntValue(), 1);
            }
            return new BigFraction(((NumberNode)node).doubleValue());
        }
        throw new ArithmeticMathException("BigFractionEvaluator#evaluateNode(ASTNode) not possible for: " + node.toString());
    }

    @Override
    public boolean evaluateNodeLogical(ASTNode node) {
        if (node instanceof FunctionNode) {
            return this.evaluateFunctionLogical((FunctionNode)node);
        }
        if (node instanceof SymbolNode) {
            BooleanVariable v = (BooleanVariable)this.fBooleanVariables.get(node.toString());
            if (v != null) {
                return v.getValue();
            }
            Boolean boole = SYMBOL_BOOLEAN_MAP.get(node.toString());
            if (boole != null) {
                return boole;
            }
        }
        throw new ArithmeticMathException("BigFractionEvaluator#evaluateNodeLogical(ASTNode) not possible for: " + node.toString());
    }

    private ASTNode getDerivativeResult(ASTNode arg1Derived, FunctionNode fun) {
        if (!arg1Derived.equals(new BigFractionNode(this.fDfpField.getOne()))) {
            FunctionNode res = new FunctionNode(this.fASTFactory.createSymbol("Times"));
            res.add(arg1Derived);
            res.add(fun);
            return res;
        }
        return fun;
    }

    @Override
    public Field<BigFraction> getField() {
        return this.fDfpField;
    }

    @Override
    public IBooleanFunction<BigFraction> getFunctionBooleanMap(String symbolName) {
        return FUNCTION_BOOLEAN_MAP.get(symbolName);
    }

    @Override
    public IFieldElementFunction<BigFraction> getFunctionMap(String symbolName) {
        return FUNCTION_MAP.get(symbolName);
    }

    @Override
    public Boolean getSymbolBooleanMap(String symbolName) {
        return SYMBOL_BOOLEAN_MAP.get(symbolName);
    }

    @Override
    public BigFraction getSymbolFieldElementMap(String symbolName) {
        return SYMBOL_MAP.get(symbolName);
    }

    @Override
    public FieldElementVariable<BigFraction> getVariable(String variableName) {
        if (this.fRelaxedSyntax) {
            return (FieldElementVariable)this.fVariableMap.get(variableName.toLowerCase());
        }
        return (FieldElementVariable)this.fVariableMap.get(variableName);
    }

    public void getVariables(ASTNode node, Set<String> result) {
        Comparable<BigFraction> obj;
        FunctionNode functionNode;
        if (node instanceof FunctionNode && !(functionNode = (FunctionNode)node).isEmpty() && functionNode.getNode(0) instanceof SymbolNode) {
            for (int i = 1; i < functionNode.size(); ++i) {
                this.getVariables(functionNode.getNode(i), result);
            }
        }
        if (node instanceof SymbolNode && (obj = SYMBOL_MAP.get(node.toString())) == null && (obj = SYMBOL_BOOLEAN_MAP.get(node.toString())) == null) {
            result.add(node.toString());
        }
    }

    public void getVariables(String expression, Set<String> result) {
        this.getVariables(expression, result, true);
    }

    public void getVariables(String expression, Set<String> result, boolean relaxedSyntax) {
        Parser p = new Parser(relaxedSyntax ? ASTNodeFactory.RELAXED_STYLE_FACTORY : ASTNodeFactory.MMA_STYLE_FACTORY, relaxedSyntax);
        ASTNode node = p.parse(expression);
        this.getVariables(node, result);
    }

    void init() {
    }

    public boolean isSymbol(SymbolNode symbol1, String symbol2Name) {
        if (this.fRelaxedSyntax) {
            return symbol1.getString().equalsIgnoreCase(symbol2Name);
        }
        return symbol1.getString().equals(symbol2Name);
    }

    public boolean isSymbol(SymbolNode symbol1, SymbolNode symbol2) {
        if (this.fRelaxedSyntax) {
            return symbol1.getString().equalsIgnoreCase(symbol2.getString());
        }
        return symbol1.equals(symbol2);
    }

    @Override
    public ASTNode optimizeFunction(FunctionNode functionNode) {
        return functionNode;
    }

    public ASTNode parse(String expression) {
        Parser p = this.fRelaxedSyntax ? new Parser(ASTNodeFactory.RELAXED_STYLE_FACTORY, true) : new Parser(ASTNodeFactory.MMA_STYLE_FACTORY, false);
        this.fNode = p.parse(expression);
        if (this.fNode instanceof FunctionNode) {
            this.fNode = this.optimizeFunction((FunctionNode)this.fNode);
        }
        return this.fNode;
    }

    @Override
    public void setUp(BigFraction data) {
        super.setUp(data);
    }

    public void setValue(FieldElementVariable<BigFraction> variable, double value) {
        variable.setValue(new BigFraction(value));
    }

    @Override
    public void tearDown() {
    }

    @Override
    public BigFraction visit(ComplexNode node) {
        return null;
    }

    @Override
    public BigFraction visit(DoubleNode node) {
        return new BigFraction(node.doubleValue());
    }

    @Override
    public BigFraction visit(FloatNode node) {
        return new BigFraction(node.doubleValue());
    }

    @Override
    public BigFraction visit(FractionNode node) {
        return new BigFraction(new BigInteger(node.getNumerator().getString()), new BigInteger(node.getDenominator().getString()));
    }

    @Override
    public BigFraction visit(IntegerNode node) {
        String iStr = node.getString();
        if (iStr != null) {
            return new BigFraction(new BigInteger(iStr), BigInteger.ONE);
        }
        return new BigFraction(node.getIntValue(), 1);
    }

    @Override
    public BigFraction visit(PatternNode node) {
        return null;
    }

    @Override
    public BigFraction visit(StringNode node) {
        return null;
    }

    public static String toString(BigFraction bf) {
        return bf.toString();
    }

    static {
        SYMBOL_BOOLEAN_MAP.put("False", Boolean.FALSE);
        SYMBOL_BOOLEAN_MAP.put("True", Boolean.TRUE);
        FUNCTION_BOOLEAN_MAP = new ConcurrentHashMap<String, IBooleanFunction<BigFraction>>();
        FUNCTION_BOOLEAN_MAP.put("And", (IBooleanFunction<BigFraction>)new IBooleanBoolean2Function<BigFraction>(){

            @Override
            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 && arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Not", (IBooleanFunction<BigFraction>)new IBooleanBoolean1Function<BigFraction>(){

            @Override
            public boolean evaluate(boolean arg1) {
                return !arg1;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Or", (IBooleanFunction<BigFraction>)new IBooleanBoolean2Function<BigFraction>(){

            @Override
            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 || arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Equal", (IBooleanFunction<BigFraction>)new IBooleanFieldElement2Function<BigFraction>(){

            @Override
            public boolean evaluate(BigFraction arg1, BigFraction arg2) {
                return arg1.equals(arg2);
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Greater", (IBooleanFunction<BigFraction>)new IBooleanFieldElement2Function<BigFraction>(){

            @Override
            public boolean evaluate(BigFraction arg1, BigFraction arg2) {
                return arg1.compareTo(arg2) > 0;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("GreaterEqual", (IBooleanFunction<BigFraction>)new IBooleanFieldElement2Function<BigFraction>(){

            @Override
            public boolean evaluate(BigFraction arg1, BigFraction arg2) {
                return arg1.compareTo(arg2) >= 0;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Less", (IBooleanFunction<BigFraction>)new IBooleanFieldElement2Function<BigFraction>(){

            @Override
            public boolean evaluate(BigFraction arg1, BigFraction arg2) {
                return arg1.compareTo(arg2) < 0;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("LessEqual", (IBooleanFunction<BigFraction>)new IBooleanFieldElement2Function<BigFraction>(){

            @Override
            public boolean evaluate(BigFraction arg1, BigFraction arg2) {
                return arg1.compareTo(arg2) <= 0;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Unequal", (IBooleanFunction<BigFraction>)new IBooleanFieldElement2Function<BigFraction>(){

            @Override
            public boolean evaluate(BigFraction arg1, BigFraction arg2) {
                return !arg1.equals(arg2);
            }
        });
        FUNCTION_MAP = new ConcurrentHashMap<String, IFieldElementFunction<BigFraction>>();
        FUNCTION_MAP.put("CompoundExpression", new CompoundExpressionFunction());
        FUNCTION_MAP.put("Set", new SetFunction());
        FUNCTION_MAP.put("Max", new MaxFunction());
        FUNCTION_MAP.put("Min", new MinFunction());
        FUNCTION_MAP.put("Plus", new PlusFunction());
        FUNCTION_MAP.put("Times", new TimesFunction());
        FUNCTION_MAP.put("Sign", (IFieldElementFunction<BigFraction>)new IFieldElement1Function<BigFraction>(){

            @Override
            public BigFraction evaluate(BigFraction arg1) {
                return arg1.equals(BigFraction.ZERO) ? BigFraction.ZERO : (arg1.compareTo(BigFraction.ZERO) > 0 ? BigFraction.ONE : BigFraction.MINUS_ONE);
            }
        });
        FUNCTION_MAP.put("Power", (IFieldElementFunction<BigFraction>)new IFieldElementInt2Function<BigFraction>(){

            @Override
            public BigFraction evaluate(BigFraction arg1, BigFraction arg2) {
                if (arg2.getDenominator().equals(BigInteger.ONE)) {
                    return arg1.pow(arg2.getNumerator());
                }
                throw new ArithmeticMathException("Power#evaluate(BigFraction, BigFraction) not possible for argument 2: " + arg2.toString());
            }

            @Override
            public BigFraction evaluate(BigFraction arg1, int n) {
                return arg1.pow(n);
            }
        });
    }

    static class MaxFunction
    implements IFieldElementFunctionNode<BigFraction>,
    IFieldElement2Function<BigFraction> {
        MaxFunction() {
        }

        @Override
        public BigFraction evaluate(BigFraction arg1, BigFraction arg2) {
            return arg1.compareTo(arg2) > 0 ? arg1 : arg2;
        }

        @Override
        public BigFraction evaluate(IEvaluator<BigFraction> engine, FunctionNode function) {
            BigFraction result = null;
            int end = function.size();
            if (end > 1) {
                result = engine.evaluateNode(function.getNode(1));
                for (int i = 2; i < end; ++i) {
                    result = this.evaluate(result, engine.evaluateNode(function.getNode(i)));
                }
            }
            return result;
        }
    }

    static class MinFunction
    implements IFieldElementFunctionNode<BigFraction>,
    IFieldElement2Function<BigFraction> {
        MinFunction() {
        }

        @Override
        public BigFraction evaluate(BigFraction arg1, BigFraction arg2) {
            return arg1.compareTo(arg2) < 0 ? arg1 : arg2;
        }

        @Override
        public BigFraction evaluate(IEvaluator<BigFraction> engine, FunctionNode function) {
            BigFraction result = null;
            int end = function.size();
            if (end > 1) {
                result = engine.evaluateNode(function.getNode(1));
                for (int i = 2; i < end; ++i) {
                    result = this.evaluate(result, engine.evaluateNode(function.getNode(i)));
                }
            }
            return result;
        }
    }
}

