/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.parser.client.eval.dfp;

import io.lumine.mythic.lib.math3.Field;
import io.lumine.mythic.lib.math3.dfp.Dfp;
import io.lumine.mythic.lib.math3.dfp.DfpField;
import io.lumine.mythic.lib.math3.dfp.DfpMath;
import io.lumine.mythic.lib.parser.client.Parser;
import io.lumine.mythic.lib.parser.client.SyntaxError;
import io.lumine.mythic.lib.parser.client.ast.ASTNode;
import io.lumine.mythic.lib.parser.client.ast.FloatNode;
import io.lumine.mythic.lib.parser.client.ast.FractionNode;
import io.lumine.mythic.lib.parser.client.ast.FunctionNode;
import io.lumine.mythic.lib.parser.client.ast.IntegerNode;
import io.lumine.mythic.lib.parser.client.ast.NumberNode;
import io.lumine.mythic.lib.parser.client.ast.PatternNode;
import io.lumine.mythic.lib.parser.client.ast.StringNode;
import io.lumine.mythic.lib.parser.client.ast.SymbolNode;
import io.lumine.mythic.lib.parser.client.eval.BooleanVariable;
import io.lumine.mythic.lib.parser.client.eval.ComplexNode;
import io.lumine.mythic.lib.parser.client.eval.DoubleNode;
import io.lumine.mythic.lib.parser.client.eval.api.FieldElementEvaluator;
import io.lumine.mythic.lib.parser.client.eval.api.FieldElementVariable;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanBoolean1Function;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanBoolean2Function;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanFieldElement2Function;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanFunction;
import io.lumine.mythic.lib.parser.client.eval.api.IEvaluator;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElement0Function;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElement1Function;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElement2Function;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElementFunction;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElementFunctionNode;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElementInt2Function;
import io.lumine.mythic.lib.parser.client.eval.api.function.CompoundExpressionFunction;
import io.lumine.mythic.lib.parser.client.eval.api.function.PlusFunction;
import io.lumine.mythic.lib.parser.client.eval.api.function.SetFunction;
import io.lumine.mythic.lib.parser.client.eval.api.function.TimesFunction;
import io.lumine.mythic.lib.parser.client.eval.dfp.DfpNode;
import io.lumine.mythic.lib.parser.client.eval.dfp.DfpVariable;
import io.lumine.mythic.lib.parser.client.eval.dfp.IDfpCallbackFunction;
import io.lumine.mythic.lib.parser.client.math.ArithmeticMathException;
import io.lumine.mythic.lib.parser.client.operator.ASTNodeFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DfpEvaluator
extends FieldElementEvaluator<Dfp> {
    private static Map<String, Dfp> SYMBOL_MAP = new ConcurrentHashMap<String, Dfp>();
    private static Map<String, Boolean> SYMBOL_BOOLEAN_MAP = new ConcurrentHashMap<String, Boolean>();
    private static Map<String, IFieldElementFunction<Dfp>> FUNCTION_MAP;
    private static Map<String, IBooleanFunction<Dfp>> FUNCTION_BOOLEAN_MAP;
    private IDfpCallbackFunction fCallbackFunction = null;
    private final DfpField fDfpField;
    private final DfpNode fZERO;
    private ASTNode fNode;
    private final ASTNodeFactory fASTFactory;

    public static ASTNode parseNode(int decimalDigits, String expression, boolean relaxedSyntax) {
        DfpEvaluator dfpEvaluator = new DfpEvaluator(decimalDigits, relaxedSyntax);
        return dfpEvaluator.parse(expression);
    }

    public DfpEvaluator(int decimalDigits) {
        this(decimalDigits, null, false);
    }

    public DfpEvaluator(int decimalDigits, ASTNode node, boolean relaxedSyntax) {
        super(relaxedSyntax);
        this.fASTFactory = new ASTNodeFactory(relaxedSyntax);
        this.fVariableMap = new HashMap();
        this.fBooleanVariables = new HashMap();
        this.fNode = node;
        this.fDfpField = new DfpField(decimalDigits);
        this.fZERO = new DfpNode(this.fDfpField.getZero());
        this.init();
        if (this.fRelaxedSyntax && SYMBOL_MAP.get("pi") == null) {
            for (String key : SYMBOL_MAP.keySet()) {
                SYMBOL_MAP.put(key.toLowerCase(), SYMBOL_MAP.get(key));
            }
            for (String key : SYMBOL_BOOLEAN_MAP.keySet()) {
                SYMBOL_BOOLEAN_MAP.put(key.toLowerCase(), SYMBOL_BOOLEAN_MAP.get(key));
            }
            for (String key : FUNCTION_MAP.keySet()) {
                FUNCTION_MAP.put(key.toLowerCase(), FUNCTION_MAP.get(key));
            }
            for (String key : FUNCTION_BOOLEAN_MAP.keySet()) {
                FUNCTION_BOOLEAN_MAP.put(key.toLowerCase(), FUNCTION_BOOLEAN_MAP.get(key));
            }
        }
    }

    public DfpEvaluator(int decimalDigits, boolean relaxedSyntax) {
        this(decimalDigits, null, relaxedSyntax);
    }

    @Override
    public void clearVariables() {
        this.fVariableMap.clear();
        this.fBooleanVariables.clear();
    }

    @Override
    public FieldElementVariable<Dfp> createVariable(Dfp value) {
        return new DfpVariable(value);
    }

    public void defineVariable(String variableName) {
        if (this.fRelaxedSyntax) {
            this.fVariableMap.put(variableName.toLowerCase(), new DfpVariable(this.fDfpField.getZero()));
        } else {
            this.fVariableMap.put(variableName, new DfpVariable(this.fDfpField.getZero()));
        }
    }

    @Override
    public void defineVariable(String variableName, BooleanVariable value) {
        if (this.fRelaxedSyntax) {
            this.fBooleanVariables.put(variableName.toLowerCase(), value);
        } else {
            this.fBooleanVariables.put(variableName, value);
        }
    }

    public void defineVariable(String variableName, Dfp value) {
        if (this.fRelaxedSyntax) {
            this.fVariableMap.put(variableName.toLowerCase(), new DfpVariable(value));
        } else {
            this.fVariableMap.put(variableName, new DfpVariable(value));
        }
    }

    public FieldElementVariable<Dfp> defineVariable(String variableName, double value) {
        DfpVariable val = new DfpVariable(this.fDfpField.newDfp(value));
        if (this.fRelaxedSyntax) {
            this.fVariableMap.put(variableName.toLowerCase(), val);
        } else {
            this.fVariableMap.put(variableName, val);
        }
        return val;
    }

    @Override
    public void defineVariable(String variableName, FieldElementVariable<Dfp> value) {
        if (this.fRelaxedSyntax) {
            this.fVariableMap.put(variableName.toLowerCase(), value);
        } else {
            this.fVariableMap.put(variableName, value);
        }
    }

    public ASTNode derivative(ASTNode node, String var) {
        SymbolNode sym = this.fASTFactory.createSymbol(var);
        return this.derivative(node, sym);
    }

    public ASTNode derivative(ASTNode node, SymbolNode var) {
        if (node.isFree(var)) {
            return new DfpNode(this.fDfpField.getZero());
        }
        if (node instanceof FunctionNode) {
            FunctionNode f = (FunctionNode)node;
            if (f.size() > 1 && f.getNode(0) instanceof SymbolNode) {
                SymbolNode head = (SymbolNode)f.getNode(0);
                if (f.size() == 2) {
                    ASTNode arg1Derived = this.derivative(f.getNode(1), var);
                    if (this.isSymbol(head, "Exp")) {
                        FunctionNode fun = new FunctionNode(this.fASTFactory.createSymbol("Exp"));
                        fun.add(f.getNode(1));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                    if (this.isSymbol(head, "Cos")) {
                        FunctionNode fun = new FunctionNode(this.fASTFactory.createSymbol("Times"));
                        fun.add(new DfpNode(this.fDfpField.newDfp(-1)));
                        fun.add(new FunctionNode(this.fASTFactory.createSymbol("Cos"), f.getNode(1)));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                    if (this.isSymbol(head, "Sin")) {
                        FunctionNode fun = new FunctionNode(this.fASTFactory.createSymbol("Cos"));
                        fun.add(f.getNode(1));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                } else if (f.size() == 3 && this.isSymbol(head, "Power")) {
                    if (f.get(2).isFree(var)) {
                        ASTNode arg1Derived = this.derivative(f.getNode(1), var);
                        FunctionNode exponent = this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Plus"), new DfpNode(this.fDfpField.newDfp(-1)), f.get(2));
                        FunctionNode fun = this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Times"), f.get(2), this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Power"), f.get(1), exponent));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                    if (f.get(1).isFree(var)) {
                        ASTNode arg2Derived = this.derivative(f.getNode(2), var);
                        FunctionNode fun = this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Times"), this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Log"), f.get(1)), f);
                        return this.getDerivativeResult(arg2Derived, fun);
                    }
                } else {
                    if (this.isSymbol(head, "Plus")) {
                        FunctionNode result = new FunctionNode(f.getNode(0));
                        for (int i = 1; i < f.size(); ++i) {
                            ASTNode deriv = this.derivative(f.getNode(i), var);
                            if (deriv.equals(this.fZERO)) continue;
                            result.add(deriv);
                        }
                        return result;
                    }
                    if (this.isSymbol(head, "Times")) {
                        FunctionNode plusResult = new FunctionNode(this.fASTFactory.createSymbol("Plus"));
                        for (int i = 1; i < f.size(); ++i) {
                            FunctionNode timesResult = new FunctionNode(f.getNode(0));
                            boolean valid = true;
                            for (int j = 1; j < f.size(); ++j) {
                                if (j == i) {
                                    ASTNode deriv = this.derivative(f.getNode(j), var);
                                    if (deriv.equals(this.fZERO)) {
                                        valid = false;
                                        continue;
                                    }
                                    timesResult.add(deriv);
                                    continue;
                                }
                                timesResult.add(f.getNode(j));
                            }
                            if (!valid) continue;
                            plusResult.add(timesResult);
                        }
                        return plusResult;
                    }
                }
            }
            return new FunctionNode(new SymbolNode("D"), node, var);
        }
        if (node instanceof SymbolNode) {
            if (this.isSymbol((SymbolNode)node, var)) {
                return new DfpNode(this.fDfpField.getOne());
            }
            FieldElementVariable v = (FieldElementVariable)this.fVariableMap.get(node.toString());
            if (v != null) {
                return new DfpNode(this.fDfpField.getZero());
            }
            Dfp dbl = SYMBOL_MAP.get(node.toString());
            if (dbl != null) {
                return new DfpNode(this.fDfpField.getZero());
            }
            return new DfpNode(this.fDfpField.getZero());
        }
        if (node instanceof NumberNode) {
            return new DfpNode(this.fDfpField.getZero());
        }
        throw new ArithmeticMathException("DfpEvaluator#derivative(ASTNode, SymbolNode) not possible for: " + node.toString());
    }

    @Override
    public Dfp evaluate() {
        if (this.fNode == null) {
            throw new SyntaxError(0, 0, 0, " ", "No parser input defined", 1);
        }
        return this.evaluateNode(this.fNode);
    }

    @Override
    public Dfp evaluate(String expression) {
        Parser p = this.fRelaxedSyntax ? new Parser(ASTNodeFactory.RELAXED_STYLE_FACTORY, true) : new Parser(ASTNodeFactory.MMA_STYLE_FACTORY, false);
        this.fNode = p.parse(expression);
        if (this.fNode instanceof FunctionNode) {
            this.fNode = this.optimizeFunction((FunctionNode)this.fNode);
        }
        return this.evaluateNode(this.fNode);
    }

    public Dfp evaluateFunction(FunctionNode functionNode) {
        if (functionNode.size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            String symbol = functionNode.getNode(0).toString();
            if (symbol.equals("If") || this.fRelaxedSyntax && symbol.equalsIgnoreCase("if")) {
                if (functionNode.size() == 3) {
                    if (this.evaluateNodeLogical(functionNode.getNode(1))) {
                        return this.evaluateNode(functionNode.getNode(2));
                    }
                } else if (functionNode.size() == 4) {
                    if (this.evaluateNodeLogical(functionNode.getNode(1))) {
                        return this.evaluateNode(functionNode.getNode(2));
                    }
                    return this.evaluateNode(functionNode.getNode(3));
                }
            } else {
                IFieldElementFunction<Dfp> function = FUNCTION_MAP.get(symbol);
                if (function instanceof IFieldElementFunctionNode) {
                    return ((IFieldElementFunctionNode)function).evaluate(this, functionNode);
                }
                if (functionNode.size() == 1) {
                    if (function instanceof IFieldElement0Function) {
                        return (Dfp)((IFieldElement0Function)function).evaluate();
                    }
                } else if (functionNode.size() == 2) {
                    if (function instanceof IFieldElement1Function) {
                        return ((IFieldElement1Function)function).evaluate(this.evaluateNode(functionNode.getNode(1)));
                    }
                } else if (functionNode.size() == 3) {
                    ASTNode arg2 = functionNode.getNode(2);
                    if (function instanceof IFieldElementInt2Function && arg2 instanceof IntegerNode) {
                        return ((IFieldElementInt2Function)function).evaluate(this.evaluateNode(functionNode.getNode(1)), ((IntegerNode)arg2).getIntValue());
                    }
                    if (function instanceof IFieldElement2Function) {
                        return ((IFieldElement2Function)function).evaluate(this.evaluateNode(functionNode.getNode(1)), this.evaluateNode(arg2));
                    }
                }
                if (this.fCallbackFunction != null) {
                    Dfp[] dfpArgs = new Dfp[functionNode.size() - 1];
                    for (int i = 0; i < dfpArgs.length; ++i) {
                        dfpArgs[i] = this.evaluateNode(functionNode.getNode(i + 1));
                    }
                    return this.fCallbackFunction.evaluate(this, functionNode, dfpArgs);
                }
            }
        }
        throw new ArithmeticMathException("DfpEvaluator#evaluateFunction(FunctionNode) not possible for: " + functionNode.toString());
    }

    @Override
    public boolean evaluateFunctionLogical(FunctionNode functionNode) {
        if (functionNode.size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            String symbol = functionNode.getNode(0).toString();
            if (functionNode.size() == 2) {
                IBooleanFunction<Dfp> function = FUNCTION_BOOLEAN_MAP.get(symbol);
                if (function instanceof IBooleanBoolean1Function) {
                    return ((IBooleanBoolean1Function)function).evaluate(this.evaluateNodeLogical(functionNode.getNode(1)));
                }
            } else if (functionNode.size() == 3) {
                IBooleanFunction<Dfp> function = FUNCTION_BOOLEAN_MAP.get(symbol);
                if (function instanceof IBooleanFieldElement2Function) {
                    return ((IBooleanFieldElement2Function)function).evaluate(this.evaluateNode(functionNode.getNode(1)), this.evaluateNode(functionNode.getNode(2)));
                }
                if (function instanceof IBooleanBoolean2Function) {
                    return ((IBooleanBoolean2Function)function).evaluate(this.evaluateNodeLogical(functionNode.getNode(1)), this.evaluateNodeLogical(functionNode.getNode(2)));
                }
            }
        }
        throw new ArithmeticMathException("DfpEvaluator#evaluateFunctionLogical(FunctionNode) not possible for: " + functionNode.toString());
    }

    @Override
    public Dfp evaluateNode(ASTNode node) {
        if (node instanceof DfpNode) {
            return this.fDfpField.newDfp(((DfpNode)node).getDfpValue());
        }
        if (node instanceof FunctionNode) {
            return this.evaluateFunction((FunctionNode)node);
        }
        if (node instanceof SymbolNode) {
            FieldElementVariable v = (FieldElementVariable)this.fVariableMap.get(node.toString());
            if (v != null) {
                return (Dfp)v.getValue();
            }
            Dfp dbl = SYMBOL_MAP.get(node.toString());
            if (dbl != null) {
                return dbl;
            }
        } else if (node instanceof NumberNode) {
            if (node instanceof FractionNode) {
                return this.fDfpField.newDfp(((FractionNode)node).getNumerator().toString()).divide(this.fDfpField.newDfp(((FractionNode)node).getDenominator().toString()));
            }
            if (node instanceof IntegerNode) {
                String iStr = ((NumberNode)node).getString();
                if (iStr != null) {
                    return this.fDfpField.newDfp(iStr);
                }
                return this.fDfpField.newDfp(((IntegerNode)node).getIntValue());
            }
            return this.fDfpField.newDfp(((NumberNode)node).getString());
        }
        throw new ArithmeticMathException("DfpEvaluator#evaluateNode(ASTNode) not possible for: " + node.toString());
    }

    @Override
    public boolean evaluateNodeLogical(ASTNode node) {
        if (node instanceof FunctionNode) {
            return this.evaluateFunctionLogical((FunctionNode)node);
        }
        if (node instanceof SymbolNode) {
            BooleanVariable v = (BooleanVariable)this.fBooleanVariables.get(node.toString());
            if (v != null) {
                return v.getValue();
            }
            Boolean boole = SYMBOL_BOOLEAN_MAP.get(node.toString());
            if (boole != null) {
                return boole;
            }
        }
        throw new ArithmeticMathException("DfpEvaluator#evaluateNodeLogical(ASTNode) not possible for: " + node.toString());
    }

    public IDfpCallbackFunction getCallbackFunction() {
        return this.fCallbackFunction;
    }

    private ASTNode getDerivativeResult(ASTNode arg1Derived, FunctionNode fun) {
        if (!arg1Derived.equals(new DfpNode(this.fDfpField.getOne()))) {
            FunctionNode res = new FunctionNode(this.fASTFactory.createSymbol("Times"));
            res.add(arg1Derived);
            res.add(fun);
            return res;
        }
        return fun;
    }

    @Override
    public Field<Dfp> getField() {
        return this.fDfpField;
    }

    @Override
    public IBooleanFunction<Dfp> getFunctionBooleanMap(String symbolName) {
        return FUNCTION_BOOLEAN_MAP.get(symbolName);
    }

    @Override
    public IFieldElementFunction<Dfp> getFunctionMap(String symbolName) {
        return FUNCTION_MAP.get(symbolName);
    }

    @Override
    public Boolean getSymbolBooleanMap(String symbolName) {
        return SYMBOL_BOOLEAN_MAP.get(symbolName);
    }

    @Override
    public Dfp getSymbolFieldElementMap(String symbolName) {
        return SYMBOL_MAP.get(symbolName);
    }

    @Override
    public FieldElementVariable<Dfp> getVariable(String variableName) {
        if (this.fRelaxedSyntax) {
            return (FieldElementVariable)this.fVariableMap.get(variableName.toLowerCase());
        }
        return (FieldElementVariable)this.fVariableMap.get(variableName);
    }

    public void getVariables(ASTNode node, Set<String> result) {
        Object obj;
        FunctionNode functionNode;
        if (node instanceof FunctionNode && (functionNode = (FunctionNode)node).size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            for (int i = 1; i < functionNode.size(); ++i) {
                this.getVariables(functionNode.getNode(i), result);
            }
        }
        if (node instanceof SymbolNode && (obj = SYMBOL_MAP.get(node.toString())) == null && (obj = SYMBOL_BOOLEAN_MAP.get(node.toString())) == null) {
            result.add(node.toString());
        }
    }

    public void getVariables(String expression, Set<String> result) {
        this.getVariables(expression, result, true);
    }

    public void getVariables(String expression, Set<String> result, boolean relaxedSyntax) {
        Parser p = new Parser(relaxedSyntax ? ASTNodeFactory.RELAXED_STYLE_FACTORY : ASTNodeFactory.MMA_STYLE_FACTORY, relaxedSyntax);
        ASTNode node = p.parse(expression);
        this.getVariables(node, result);
    }

    void init() {
        SYMBOL_MAP.put("Catalan", this.fDfpField.newDfp(0.915965594177219));
        SYMBOL_MAP.put("Degree", this.fDfpField.newDfp(Math.PI / 180));
        SYMBOL_MAP.put("E", this.fDfpField.getE());
        SYMBOL_MAP.put("Pi", this.fDfpField.getPi());
        SYMBOL_MAP.put("EulerGamma", this.fDfpField.newDfp(0.5772156649015329));
        SYMBOL_MAP.put("Glaisher", this.fDfpField.newDfp(1.2824271291006226));
        SYMBOL_MAP.put("GoldenRatio", this.fDfpField.newDfp(1.618033988749895));
        SYMBOL_MAP.put("Khinchin", this.fDfpField.newDfp(2.6854520010653062));
    }

    public boolean isSymbol(SymbolNode symbol1, String symbol2Name) {
        if (this.fRelaxedSyntax) {
            return symbol1.getString().equalsIgnoreCase(symbol2Name);
        }
        return symbol1.getString().equals(symbol2Name);
    }

    public boolean isSymbol(SymbolNode symbol1, SymbolNode symbol2) {
        if (this.fRelaxedSyntax) {
            return symbol1.getString().equalsIgnoreCase(symbol2.getString());
        }
        return symbol1.equals(symbol2);
    }

    @Override
    public ASTNode optimizeFunction(FunctionNode functionNode) {
        if (functionNode.size() > 0) {
            boolean dfpOnly = true;
            for (int i = 1; i < functionNode.size(); ++i) {
                ASTNode node = functionNode.getNode(i);
                if (node instanceof NumberNode) {
                    if (node instanceof FractionNode) {
                        functionNode.set(i, new DfpNode(this.fDfpField.newDfp(((FractionNode)node).getNumerator().toString()).divide(this.fDfpField.newDfp(((FractionNode)node).getDenominator().toString()))));
                        continue;
                    }
                    if (node instanceof IntegerNode) {
                        String iStr = ((NumberNode)functionNode.getNode(i)).getString();
                        if (iStr != null) {
                            functionNode.set(i, new DfpNode(this.fDfpField.newDfp(iStr)));
                            continue;
                        }
                        functionNode.set(i, new DfpNode(this.fDfpField.newDfp(((IntegerNode)functionNode.getNode(i)).getIntValue())));
                        continue;
                    }
                    functionNode.set(i, new DfpNode(this.fDfpField.newDfp(((NumberNode)functionNode.getNode(i)).getString())));
                    continue;
                }
                if (functionNode.getNode(i) instanceof FunctionNode) {
                    ASTNode optNode = this.optimizeFunction((FunctionNode)functionNode.getNode(i));
                    if (!(optNode instanceof DfpNode)) {
                        dfpOnly = false;
                    }
                    functionNode.set(i, optNode);
                    continue;
                }
                if (node instanceof SymbolNode) {
                    Dfp dbl = SYMBOL_MAP.get(node.toString());
                    if (dbl != null) {
                        functionNode.set(i, new DfpNode(dbl));
                        continue;
                    }
                    dfpOnly = false;
                    continue;
                }
                dfpOnly = false;
            }
            if (dfpOnly) {
                try {
                    return new DfpNode(this.evaluateFunction(functionNode));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return functionNode;
    }

    public ASTNode parse(String expression) {
        Parser p = this.fRelaxedSyntax ? new Parser(ASTNodeFactory.RELAXED_STYLE_FACTORY, true) : new Parser(ASTNodeFactory.MMA_STYLE_FACTORY, false);
        this.fNode = p.parse(expression);
        if (this.fNode instanceof FunctionNode) {
            this.fNode = this.optimizeFunction((FunctionNode)this.fNode);
        }
        return this.fNode;
    }

    public void setCallbackFunction(IDfpCallbackFunction callbackFunction) {
        this.fCallbackFunction = callbackFunction;
    }

    @Override
    public void setUp(Dfp data) {
        super.setUp(data);
    }

    public void setValue(FieldElementVariable<Dfp> variable, double value) {
        variable.setValue(this.fDfpField.newDfp(value));
    }

    @Override
    public void tearDown() {
    }

    @Override
    public Dfp visit(ComplexNode node) {
        return null;
    }

    @Override
    public Dfp visit(DoubleNode node) {
        return this.fDfpField.newDfp(node.getString());
    }

    @Override
    public Dfp visit(FloatNode node) {
        return this.fDfpField.newDfp(node.getString());
    }

    @Override
    public Dfp visit(FractionNode node) {
        return this.fDfpField.newDfp(node.doubleValue());
    }

    @Override
    public Dfp visit(IntegerNode node) {
        return this.fDfpField.newDfp(node.getIntValue());
    }

    @Override
    public Dfp visit(PatternNode node) {
        return null;
    }

    @Override
    public Dfp visit(StringNode node) {
        return null;
    }

    public static String toString(Dfp c) {
        return c.toString();
    }

    static {
        SYMBOL_BOOLEAN_MAP.put("False", Boolean.FALSE);
        SYMBOL_BOOLEAN_MAP.put("True", Boolean.TRUE);
        FUNCTION_BOOLEAN_MAP = new ConcurrentHashMap<String, IBooleanFunction<Dfp>>();
        FUNCTION_BOOLEAN_MAP.put("And", (IBooleanFunction<Dfp>)new IBooleanBoolean2Function<Dfp>(){

            @Override
            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 && arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Not", (IBooleanFunction<Dfp>)new IBooleanBoolean1Function<Dfp>(){

            @Override
            public boolean evaluate(boolean arg1) {
                return !arg1;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Or", (IBooleanFunction<Dfp>)new IBooleanBoolean2Function<Dfp>(){

            @Override
            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 || arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Equal", (IBooleanFunction<Dfp>)new IBooleanFieldElement2Function<Dfp>(){

            @Override
            public boolean evaluate(Dfp arg1, Dfp arg2) {
                return arg1.equals(arg2);
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Greater", (IBooleanFunction<Dfp>)new IBooleanFieldElement2Function<Dfp>(){

            @Override
            public boolean evaluate(Dfp arg1, Dfp arg2) {
                return arg1.greaterThan(arg2);
            }
        });
        FUNCTION_BOOLEAN_MAP.put("GreaterEqual", (IBooleanFunction<Dfp>)new IBooleanFieldElement2Function<Dfp>(){

            @Override
            public boolean evaluate(Dfp arg1, Dfp arg2) {
                return !arg1.lessThan(arg2);
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Less", (IBooleanFunction<Dfp>)new IBooleanFieldElement2Function<Dfp>(){

            @Override
            public boolean evaluate(Dfp arg1, Dfp arg2) {
                return arg1.lessThan(arg2);
            }
        });
        FUNCTION_BOOLEAN_MAP.put("LessEqual", (IBooleanFunction<Dfp>)new IBooleanFieldElement2Function<Dfp>(){

            @Override
            public boolean evaluate(Dfp arg1, Dfp arg2) {
                return !arg1.greaterThan(arg2);
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Unequal", (IBooleanFunction<Dfp>)new IBooleanFieldElement2Function<Dfp>(){

            @Override
            public boolean evaluate(Dfp arg1, Dfp arg2) {
                return !arg1.equals(arg2);
            }
        });
        FUNCTION_MAP = new ConcurrentHashMap<String, IFieldElementFunction<Dfp>>();
        FUNCTION_MAP.put("ArcTan", new ArcTanFunction());
        FUNCTION_MAP.put("CompoundExpression", new CompoundExpressionFunction());
        FUNCTION_MAP.put("Set", new SetFunction());
        FUNCTION_MAP.put("Log", new LogFunction());
        FUNCTION_MAP.put("Max", new MaxFunction());
        FUNCTION_MAP.put("Min", new MinFunction());
        FUNCTION_MAP.put("Plus", new PlusFunction());
        FUNCTION_MAP.put("Times", new TimesFunction());
        FUNCTION_MAP.put("ArcCos", (IFieldElementFunction<Dfp>)new IFieldElement1Function<Dfp>(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return DfpMath.acos(arg1);
            }
        });
        FUNCTION_MAP.put("ArcSin", (IFieldElementFunction<Dfp>)new IFieldElement1Function<Dfp>(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return DfpMath.asin(arg1);
            }
        });
        FUNCTION_MAP.put("Ceiling", (IFieldElementFunction<Dfp>)new IFieldElement1Function<Dfp>(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.ceil();
            }
        });
        FUNCTION_MAP.put("Cos", (IFieldElementFunction<Dfp>)new IFieldElement1Function<Dfp>(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.cos();
            }
        });
        FUNCTION_MAP.put("Cosh", (IFieldElementFunction<Dfp>)new IFieldElement1Function<Dfp>(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.cosh();
            }
        });
        FUNCTION_MAP.put("Exp", (IFieldElementFunction<Dfp>)new IFieldElement1Function<Dfp>(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return DfpMath.exp(arg1);
            }
        });
        FUNCTION_MAP.put("Floor", (IFieldElementFunction<Dfp>)new IFieldElement1Function<Dfp>(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.floor();
            }
        });
        FUNCTION_MAP.put("Sign", (IFieldElementFunction<Dfp>)new IFieldElement1Function<Dfp>(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.signum();
            }
        });
        FUNCTION_MAP.put("Sin", (IFieldElementFunction<Dfp>)new IFieldElement1Function<Dfp>(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return DfpMath.sin(arg1);
            }
        });
        FUNCTION_MAP.put("Sinh", (IFieldElementFunction<Dfp>)new IFieldElement1Function<Dfp>(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.sinh();
            }
        });
        FUNCTION_MAP.put("Sqrt", (IFieldElementFunction<Dfp>)new IFieldElement1Function<Dfp>(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.sqrt();
            }
        });
        FUNCTION_MAP.put("Tan", (IFieldElementFunction<Dfp>)new IFieldElement1Function<Dfp>(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return DfpMath.tan(arg1);
            }
        });
        FUNCTION_MAP.put("Tanh", (IFieldElementFunction<Dfp>)new IFieldElement1Function<Dfp>(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.tanh();
            }
        });
        FUNCTION_MAP.put("Power", (IFieldElementFunction<Dfp>)new IFieldElementInt2Function<Dfp>(){

            @Override
            public Dfp evaluate(Dfp arg1, Dfp arg2) {
                return arg1.pow(arg2);
            }

            @Override
            public Dfp evaluate(Dfp arg1, int n) {
                return arg1.pow(n);
            }
        });
    }

    static class ArcTanFunction
    implements IFieldElement1Function<Dfp>,
    IFieldElement2Function<Dfp> {
        ArcTanFunction() {
        }

        @Override
        public Dfp evaluate(Dfp arg1) {
            return DfpMath.atan(arg1);
        }

        @Override
        public Dfp evaluate(Dfp arg1, Dfp arg2) {
            return arg1.atan2(arg2);
        }
    }

    static class LogFunction
    implements IFieldElement1Function<Dfp>,
    IFieldElement2Function<Dfp> {
        LogFunction() {
        }

        @Override
        public Dfp evaluate(Dfp arg1) {
            return DfpMath.log(arg1);
        }

        @Override
        public Dfp evaluate(Dfp base, Dfp z) {
            return DfpMath.log(z).divide(DfpMath.log(base));
        }
    }

    static class MaxFunction
    implements IFieldElementFunctionNode<Dfp>,
    IFieldElement2Function<Dfp> {
        MaxFunction() {
        }

        @Override
        public Dfp evaluate(Dfp arg1, Dfp arg2) {
            return arg1.greaterThan(arg2) ? arg1 : arg2;
        }

        @Override
        public Dfp evaluate(IEvaluator<Dfp> engine, FunctionNode function) {
            Dfp result = null;
            int end = function.size();
            if (end > 1) {
                result = engine.evaluateNode(function.getNode(1));
                for (int i = 2; i < end; ++i) {
                    result = this.evaluate(result, engine.evaluateNode(function.getNode(i)));
                }
            }
            return result;
        }
    }

    static class MinFunction
    implements IFieldElementFunctionNode<Dfp>,
    IFieldElement2Function<Dfp> {
        MinFunction() {
        }

        @Override
        public Dfp evaluate(Dfp arg1, Dfp arg2) {
            return arg1.lessThan(arg2) ? arg1 : arg2;
        }

        @Override
        public Dfp evaluate(IEvaluator<Dfp> engine, FunctionNode function) {
            Dfp result = null;
            int end = function.size();
            if (end > 1) {
                result = engine.evaluateNode(function.getNode(1));
                for (int i = 2; i < end; ++i) {
                    result = this.evaluate(result, engine.evaluateNode(function.getNode(i)));
                }
            }
            return result;
        }
    }
}

