/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.player.modifier;

import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.player.modifier.Closeable;
import io.lumine.mythic.lib.player.modifier.PlayerModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public abstract class ModifierMap<T extends PlayerModifier> {
    private final MMOPlayerData playerData;
    private final Map<UUID, T> modifiers = new HashMap<UUID, T>();

    public ModifierMap(MMOPlayerData playerData) {
        this.playerData = playerData;
    }

    @NotNull
    public MMOPlayerData getPlayerData() {
        return this.playerData;
    }

    @NotNull
    public Collection<T> getModifiers() {
        return this.modifiers.values();
    }

    @NotNull
    public Iterable<T> isolateModifiers(EquipmentSlot hand) {
        ArrayList<PlayerModifier> isolated = new ArrayList<PlayerModifier>();
        for (PlayerModifier modifier : this.getModifiers()) {
            if (!hand.isCompatible(modifier)) continue;
            isolated.add(modifier);
        }
        return isolated;
    }

    @Nullable
    public T addModifier(T modifier) {
        return (T)((PlayerModifier)this.modifiers.put(((PlayerModifier)modifier).getUniqueId(), modifier));
    }

    @Nullable
    public T removeModifier(UUID uuid) {
        PlayerModifier removed = (PlayerModifier)this.modifiers.remove(uuid);
        if (removed != null && removed instanceof Closeable) {
            ((Closeable)((Object)removed)).close();
        }
        return (T)removed;
    }

    public void removeModifiers(String key) {
        Iterator<T> iterator = this.modifiers.values().iterator();
        while (iterator.hasNext()) {
            PlayerModifier skill = (PlayerModifier)iterator.next();
            if (!skill.getKey().equals(key)) continue;
            iterator.remove();
            if (!(skill instanceof Closeable)) continue;
            ((Closeable)((Object)skill)).close();
        }
    }
}

