/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.script.Script;
import io.lumine.mythic.lib.script.mechanic.Mechanic;
import io.lumine.mythic.lib.script.mechanic.misc.DelayMechanic;
import io.lumine.mythic.lib.skill.SkillMetadata;
import java.util.Iterator;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class MechanicQueue {
    private final Iterator<Mechanic> queue;
    private final SkillMetadata meta;
    private final Script skill;
    private int counter = 0;

    public MechanicQueue(SkillMetadata meta, Script skill) {
        this.meta = meta;
        this.queue = skill.getMechanics().iterator();
        this.skill = skill;
    }

    public boolean next() {
        if (!this.queue.hasNext()) {
            return false;
        }
        ++this.counter;
        Mechanic mechanic = this.queue.next();
        if (mechanic instanceof DelayMechanic) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicLib.plugin, () -> this.next(), ((DelayMechanic)mechanic).getDelay(this.meta));
        } else {
            try {
                mechanic.cast(this.meta);
                this.next();
            }
            catch (RuntimeException exception) {
                MythicLib.plugin.getLogger().log(Level.WARNING, "Could not execute mechanic n" + this.counter + " from skill '" + this.skill.getId() + "': " + exception.getMessage());
            }
        }
        return true;
    }
}

