/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.util.PostLoadObject;
import io.lumine.mythic.lib.script.MechanicQueue;
import io.lumine.mythic.lib.script.condition.Condition;
import io.lumine.mythic.lib.script.mechanic.Mechanic;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.configobject.ConfigSectionObject;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class Script
extends PostLoadObject {
    private final String id;
    private final boolean publicSkill;
    private final List<Condition> conditions = new ArrayList<Condition>();
    private final List<Mechanic> mechanics = new ArrayList<Mechanic>();

    public Script(@NotNull ConfigurationSection config) {
        super(config);
        this.id = config.getName();
        this.publicSkill = config.getBoolean("public", false);
    }

    public Script(String id, boolean publicSkill) {
        super(null);
        this.id = id;
        this.publicSkill = publicSkill;
    }

    @Override
    public void whenPostLoaded(@NotNull ConfigurationSection config) {
        if (config.isConfigurationSection("conditions")) {
            for (String str : config.getConfigurationSection("conditions").getKeys(false)) {
                try {
                    this.conditions.add(MythicLib.plugin.getSkills().loadCondition(new ConfigSectionObject(config.getConfigurationSection("conditions." + str))));
                }
                catch (RuntimeException exception) {
                    MythicLib.plugin.getLogger().log(Level.WARNING, "Could not load condition '" + str + "' from script '" + this.id + "': " + exception.getMessage());
                }
            }
        }
        if (config.isConfigurationSection("mechanics")) {
            for (String str : config.getConfigurationSection("mechanics").getKeys(false)) {
                try {
                    this.mechanics.add(MythicLib.plugin.getSkills().loadMechanic(new ConfigSectionObject(config.getConfigurationSection("mechanics." + str))));
                }
                catch (RuntimeException exception) {
                    MythicLib.plugin.getLogger().log(Level.WARNING, "Could not load mechanic '" + str + "' from script '" + this.id + "': " + exception.getMessage());
                }
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isPublic() {
        return this.publicSkill;
    }

    public List<Mechanic> getMechanics() {
        return this.mechanics;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public boolean cast(SkillMetadata meta) {
        for (Condition condition : this.conditions) {
            if (condition.checkIfMet(meta)) continue;
            return false;
        }
        new MechanicQueue(meta, this).next();
        return true;
    }
}

