/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.condition.location;

import io.lumine.mythic.lib.script.condition.type.LocationCondition;
import io.lumine.mythic.lib.script.variable.Variable;
import io.lumine.mythic.lib.script.variable.def.PositionVariable;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.Position;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class CuboidCondition
extends LocationCondition {
    private final String varName1;
    private final String varName2;

    public CuboidCondition(ConfigObject config) {
        super(config, false);
        config.validateKeys("first", "second", "third");
        this.varName1 = config.getString("loc1");
        this.varName2 = config.getString("loc2");
    }

    @Override
    public boolean isMet(SkillMetadata meta, Location loc) {
        Variable var1 = meta.getReference(this.varName1);
        Validate.isTrue((boolean)(var1 instanceof PositionVariable), (String)("Variable '" + this.varName1 + "' is not a vector"));
        Vector vec1 = ((Position)var1.getStored()).toVector();
        Variable var2 = meta.getReference(this.varName1);
        Validate.isTrue((boolean)(var2 instanceof PositionVariable), (String)("Variable '" + this.varName2 + "' is not a vector"));
        Vector vec2 = ((Position)var2.getStored()).toVector();
        return BoundingBox.of((Vector)vec1, (Vector)vec2).contains(loc.toVector());
    }
}

