/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.mechanic.buff;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.script.mechanic.MechanicMetadata;
import io.lumine.mythic.lib.script.mechanic.type.TargetMechanic;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.DoubleFormula;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityRegainHealthEvent;

@MechanicMetadata
public class SaturateMechanic
extends TargetMechanic {
    private final DoubleFormula amount;
    private final EntityRegainHealthEvent.RegainReason reason;

    public SaturateMechanic(ConfigObject config) {
        super(config);
        config.validateKeys("amount");
        this.amount = new DoubleFormula(config.getString("amount"));
        this.reason = EntityRegainHealthEvent.RegainReason.valueOf((String)UtilityMethods.enumName(config.getString("reason", "CUSTOM")));
    }

    @Override
    public void cast(SkillMetadata meta, Entity target) {
        Validate.isTrue((boolean)(target instanceof Player), (String)"Can only give saturation to a player");
        Player player = (Player)target;
        player.setSaturation((float)Math.max(0.0, this.amount.evaluate(meta)));
    }
}

