/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.mechanic.raytrace;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.script.Script;
import io.lumine.mythic.lib.script.mechanic.MechanicMetadata;
import io.lumine.mythic.lib.script.mechanic.type.DirectionMechanic;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import org.apache.commons.lang.Validate;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

@MechanicMetadata
public class RayTraceAnyMechanic
extends DirectionMechanic {
    private final double range;
    private final double size;
    private final double step;
    private final Script onHitBlock;
    private final Script onHitEntity;
    private final Script onTick;
    private final boolean ignorePassable;
    private static final double DEFAULT_RANGE = 50.0;
    private static final double DEFAULT_SIZE = 0.2;
    private static final double DEFAULT_STEP = 0.4;

    public RayTraceAnyMechanic(ConfigObject config) {
        super(config);
        this.onTick = config.contains("tick") ? MythicLib.plugin.getSkills().getScriptOrThrow(config.getString("tick")) : null;
        this.onHitEntity = config.contains("hit_entity") ? MythicLib.plugin.getSkills().getScriptOrThrow(config.getString("hit_entity")) : null;
        this.onHitBlock = config.contains("hit_block") ? MythicLib.plugin.getSkills().getScriptOrThrow(config.getString("hit_block")) : null;
        this.ignorePassable = config.getBoolean("ignore-passable", false);
        this.range = config.getDouble("range", 50.0);
        this.size = config.getDouble("size", 0.2);
        this.step = config.getDouble("step", 0.4);
        Validate.isTrue((this.range > 0.0 ? 1 : 0) != 0, (String)"Range must be strictly positive");
        Validate.isTrue((this.size >= 0.0 ? 1 : 0) != 0, (String)"Size must be positive or null");
        Validate.isTrue((this.step > 0.0 ? 1 : 0) != 0, (String)"Step must be strictly positive (don't make it too low)");
    }

    @Override
    public void cast(SkillMetadata meta, Location source, Vector dir2) {
        double length;
        Validate.isTrue((dir2.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction cannot be zero");
        dir2.normalize();
        RayTraceResult result = source.getWorld().rayTrace(source, dir2, this.range, FluidCollisionMode.NEVER, this.ignorePassable, this.size, entity -> entity instanceof LivingEntity && !entity.equals(meta.getCaster().getPlayer()));
        double d = length = result == null ? this.range : result.getHitPosition().distance(source.toVector());
        if (this.onTick != null) {
            for (double j = 0.0; j < length; j += this.step) {
                Location intermediate = source.clone().add(dir2.clone().multiply(j));
                this.onTick.cast(meta.clone(source, intermediate, null, null));
            }
        }
        if (result == null) {
            return;
        }
        Location hitPosition = result.getHitPosition().toLocation(source.getWorld());
        if (this.onHitBlock != null && result.getHitBlock() != null) {
            this.onHitBlock.cast(meta.clone(source, hitPosition, null, null));
        }
        if (this.onHitEntity != null && result.getHitEntity() != null) {
            this.onHitEntity.cast(meta.clone(source, hitPosition, result.getHitEntity(), null));
        }
    }
}

