/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.mechanic.raytrace;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.script.Script;
import io.lumine.mythic.lib.script.mechanic.MechanicMetadata;
import io.lumine.mythic.lib.script.mechanic.type.DirectionMechanic;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import org.apache.commons.lang.Validate;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

@MechanicMetadata
public class RayTraceBlocksMechanic
extends DirectionMechanic {
    private final double range;
    private final double step;
    private final Script onHit;
    private final Script onTick;
    private final boolean ignorePassable;
    private static final double DEFAULT_RANGE = 50.0;
    private static final double DEFAULT_STEP = 0.4;

    public RayTraceBlocksMechanic(ConfigObject config) {
        super(config);
        this.onTick = config.contains("tick") ? MythicLib.plugin.getSkills().getScriptOrThrow(config.getString("tick")) : null;
        this.onHit = config.contains("hit_block") ? MythicLib.plugin.getSkills().getScriptOrThrow(config.getString("hit_block")) : null;
        this.ignorePassable = config.getBoolean("ignore_passable", false);
        this.range = config.getDouble("range", 50.0);
        this.step = config.getDouble("step", 0.4);
        Validate.isTrue((this.range > 0.0 ? 1 : 0) != 0, (String)"Range must be strictly positive");
        Validate.isTrue((this.step > 0.0 ? 1 : 0) != 0, (String)"Step must be strictly positive (don't make it too low)");
    }

    @Override
    public void cast(SkillMetadata meta, Location source, Vector dir2) {
        double length;
        Validate.isTrue((dir2.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction cannot be zero");
        dir2.normalize();
        RayTraceResult result = source.getWorld().rayTraceBlocks(source, dir2, this.range, FluidCollisionMode.NEVER, this.ignorePassable);
        double d = length = result == null ? this.range : result.getHitPosition().distance(source.toVector());
        if (this.onTick != null) {
            for (double j = 0.0; j < length; j += this.step) {
                Location intermediate = source.clone().add(dir2.clone().multiply(j));
                this.onTick.cast(meta.clone(source, intermediate, null, null));
            }
        }
        if (result != null && this.onHit != null && result.getHitBlock() != null) {
            Location hitPosition = result.getHitPosition().toLocation(source.getWorld());
            this.onHit.cast(meta.clone(source, hitPosition, null, null));
        }
    }
}

