/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.mechanic.shaped;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.script.Script;
import io.lumine.mythic.lib.script.mechanic.Mechanic;
import io.lumine.mythic.lib.script.targeter.LocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.SourceLocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.TargetLocationTargeter;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ParabolaMechanic
extends Mechanic {
    private final double height;
    private final double speed;
    private final LocationTargeter sourceLocation;
    private final LocationTargeter targetLocation;
    private final Script onStart;
    private final Script onTick;
    private final Script onEnd;

    public ParabolaMechanic(ConfigObject config) {
        this.sourceLocation = config.contains("source") ? MythicLib.plugin.getSkills().loadLocationTargeter(config.getObject("source")) : new SourceLocationTargeter();
        this.targetLocation = config.contains("target") ? MythicLib.plugin.getSkills().loadLocationTargeter(config.getObject("target")) : new TargetLocationTargeter();
        config.validateKeys("tick");
        this.onStart = config.contains("start") ? MythicLib.plugin.getSkills().getScriptOrThrow(config.getString("start")) : null;
        this.onTick = MythicLib.plugin.getSkills().getScriptOrThrow(config.getString("tick"));
        this.onEnd = config.contains("end") ? MythicLib.plugin.getSkills().getScriptOrThrow(config.getString("end")) : null;
        this.height = config.getDouble("height");
        this.speed = config.getDouble("speed", 1.0);
        Validate.isTrue((this.speed > 0.0 ? 1 : 0) != 0, (String)"Speed must be strictly positive");
    }

    @Override
    public void cast(SkillMetadata meta) {
        Location source = this.sourceLocation.findTargets(meta).get(0);
        for (Location loc : this.targetLocation.findTargets(meta)) {
            this.cast(meta, source, loc.clone().subtract(source).toVector());
        }
    }

    public void cast(final SkillMetadata meta, final Location source, final Vector dir2) {
        Validate.isTrue((dir2.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction cannot be zero");
        final double xzLength = dir2.clone().setY(0).length();
        double height = this.height + Math.max(0.0, dir2.getY());
        final double a = (2.0 * dir2.getY() - 4.0 * height) / (xzLength * xzLength);
        final double b = xzLength - dir2.getY() / (a * xzLength);
        new BukkitRunnable(){
            double x = 0.0;
            private static final double DT = 0.05;
            private static final double STEP = 0.3;
            private final Vector axis = dir2.clone().setY(0).normalize();

            public void run() {
                boolean ending;
                double dx = ParabolaMechanic.this.speed * 0.05;
                double dy = ParabolaMechanic.this.getLength(a, b, this.x, this.x + dx);
                int displayed = (int)(dy / 0.3);
                double xStep = dx / (double)displayed;
                boolean bl = ending = this.x + dx >= xzLength;
                Script cast = this.x == 0.0 ? ParabolaMechanic.this.onStart : (ending ? ParabolaMechanic.this.onEnd : ParabolaMechanic.this.onTick);
                for (int i = 0; i < displayed; ++i) {
                    double x_i = this.x + (double)i * xStep;
                    Location loc_i = source.clone().add(this.axis.multiply(x_i)).add(0.0, ParabolaMechanic.this.y(a, b, x_i), 0.0);
                    cast.cast(meta.clone(source, loc_i, null, null));
                }
                this.x += dx;
                if (ending) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
    }

    private double y(double a, double b, double x) {
        return a * x * (x - b);
    }

    private double getLength(double a, double b, double x1, double x2) {
        double u1 = this.u(a, b, x1);
        double u2 = this.u(a, b, x2);
        return (this.primitive(u2) - this.primitive(u1)) / (2.0 * a);
    }

    private double u(double a, double b, double x) {
        return a * (2.0 * x - b);
    }

    private double primitive(double x) {
        return 0.5 * x + 0.25 * Math.sinh(2.0 * x);
    }
}

