/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.mechanic.shaped;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.script.Script;
import io.lumine.mythic.lib.script.mechanic.Mechanic;
import io.lumine.mythic.lib.script.targeter.LocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.DefaultDirectionTargeter;
import io.lumine.mythic.lib.script.targeter.location.DefaultLocationTargeter;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SlashMechanic
extends Mechanic {
    private final double length;
    private final double angle;
    private final double distance;
    private final long points;
    private final long timeInterval;
    private final long pointsPerTick;
    private final LocationTargeter sourceLocation;
    private final LocationTargeter targetLocation;
    private final Script onStart;
    private final Script onTick;
    private final Script onEnd;

    public SlashMechanic(ConfigObject config) {
        this.sourceLocation = config.contains("source") ? MythicLib.plugin.getSkills().loadLocationTargeter(config.getObject("source")) : new DefaultLocationTargeter();
        this.targetLocation = config.contains("target") ? MythicLib.plugin.getSkills().loadLocationTargeter(config.getObject("target")) : new DefaultDirectionTargeter();
        config.validateKeys("tick");
        this.onStart = config.contains("start") ? MythicLib.plugin.getSkills().getScriptOrThrow(config.getString("start")) : null;
        this.onTick = MythicLib.plugin.getSkills().getScriptOrThrow(config.getString("tick"));
        this.onEnd = config.contains("end") ? MythicLib.plugin.getSkills().getScriptOrThrow(config.getString("end")) : null;
        this.distance = config.getDouble("distance", 3.0);
        this.length = config.getDouble("length", 4.0);
        this.angle = config.getDouble("angle", -30.0);
        this.points = config.getInt("points", 20);
        this.timeInterval = config.getInt("time_interval", 1);
        this.pointsPerTick = config.getInt("points_per_tick", 1);
        Validate.isTrue((this.length > 0.0 ? 1 : 0) != 0, (String)"Length must be strictly positive");
        Validate.isTrue((this.points > 0L ? 1 : 0) != 0, (String)"Points must be strictly positive");
        Validate.isTrue((this.timeInterval > 0L ? 1 : 0) != 0, (String)"Time interval must be strictly positive");
        Validate.isTrue((this.pointsPerTick > 0L ? 1 : 0) != 0, (String)"Points per tick must be strictly positive");
    }

    @Override
    public void cast(SkillMetadata meta) {
        Location source = this.sourceLocation.findTargets(meta).get(0);
        for (Location loc : this.targetLocation.findTargets(meta)) {
            this.cast(meta, source, loc.clone().subtract(source).toVector());
        }
    }

    public void cast(final SkillMetadata meta, final Location source, final Vector dir2) {
        Validate.isTrue((dir2.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction cannot be zero");
        Vector radialAxis = dir2.clone().normalize();
        final Vector slashDirection = dir2.clone().setY(0).rotateAroundY(-1.5707963267948966).rotateAroundAxis(radialAxis, Math.toRadians(this.angle)).normalize();
        new BukkitRunnable(){
            int counter = 0;
            final Location current = source.clone().add(slashDirection.clone().multiply(-SlashMechanic.access$000(SlashMechanic.this) / 2.0));
            final Vector incremented = slashDirection.clone().multiply(SlashMechanic.access$000(SlashMechanic.this) / (double)SlashMechanic.access$100(SlashMechanic.this));

            public void run() {
                int i = 0;
                while ((long)i < SlashMechanic.this.pointsPerTick) {
                    boolean ending;
                    this.current.add(this.incremented);
                    double x = (double)Math.abs((long)this.counter - SlashMechanic.this.points / 2L) * 2.0 / (double)SlashMechanic.this.points;
                    boolean bl = ending = (long)(this.counter + 1) >= SlashMechanic.this.points;
                    Script cast = this.counter == 0 ? SlashMechanic.this.onStart : (ending ? SlashMechanic.this.onEnd : SlashMechanic.this.onTick);
                    Location intermediate = this.current.clone().add(dir2.clone().multiply(SlashMechanic.this.distance * Math.sqrt(1.0 - x * x)));
                    cast.cast(meta.clone(source, intermediate, null, null));
                    ++this.counter;
                    if (ending) {
                        this.cancel();
                    }
                    ++i;
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, this.timeInterval);
    }

    static /* synthetic */ double access$000(SlashMechanic x0) {
        return x0.length;
    }
}

