/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.mechanic.type;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.script.mechanic.Mechanic;
import io.lumine.mythic.lib.script.targeter.LocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.CasterLocationTargeter;
import io.lumine.mythic.lib.script.targeter.location.DefaultDirectionTargeter;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.EntityLocationType;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public abstract class DirectionMechanic
extends Mechanic {
    private final LocationTargeter sourceLocation;
    private final LocationTargeter targetLocation;

    public DirectionMechanic(ConfigObject config) {
        this.sourceLocation = config.contains("source") ? MythicLib.plugin.getSkills().loadLocationTargeter(config.getObject("source")) : new CasterLocationTargeter(EntityLocationType.EYES);
        this.targetLocation = config.contains("target") ? MythicLib.plugin.getSkills().loadLocationTargeter(config.getObject("target")) : new DefaultDirectionTargeter();
    }

    public LocationTargeter getSource() {
        return this.sourceLocation;
    }

    public LocationTargeter getTarget() {
        return this.targetLocation;
    }

    @Override
    public void cast(SkillMetadata meta) {
        Location source = this.sourceLocation.findTargets(meta).get(0);
        for (Location loc : this.targetLocation.findTargets(meta)) {
            this.cast(meta, source, loc.clone().subtract(source).toVector());
        }
    }

    public abstract void cast(SkillMetadata var1, Location var2, Vector var3);
}

