/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.mechanic.variable.vector;

import io.lumine.mythic.lib.script.mechanic.MechanicMetadata;
import io.lumine.mythic.lib.script.mechanic.variable.VariableMechanic;
import io.lumine.mythic.lib.script.variable.Variable;
import io.lumine.mythic.lib.script.variable.def.PositionVariable;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.Position;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import org.apache.commons.lang.Validate;

@MechanicMetadata
public class CrossProductMechanic
extends VariableMechanic {
    private final String varName1;
    private final String varName2;

    public CrossProductMechanic(ConfigObject config) {
        super(config);
        config.validateKeys("vec1", "vec2");
        this.varName1 = config.getString("vec1");
        this.varName2 = config.getString("vec2");
    }

    @Override
    public void cast(SkillMetadata meta) {
        Variable var1 = meta.getCustomVariable(this.varName1);
        Validate.isTrue((boolean)(var1 instanceof PositionVariable), (String)("Variable '" + this.varName1 + "' is not a vector"));
        Position pos1 = (Position)var1.getStored();
        Variable var2 = meta.getCustomVariable(this.varName2);
        Validate.isTrue((boolean)(var2 instanceof PositionVariable), (String)("Variable '" + this.varName2 + "' is not a vector"));
        Position pos2 = (Position)var2.getStored();
        this.getTargetVariableList(meta).registerVariable(new PositionVariable(this.getVariableName(), pos1.getCrossProduct(pos2)));
    }
}

