/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.variable;

import io.lumine.mythic.lib.script.variable.Variable;
import io.lumine.mythic.lib.script.variable.VariableMetadata;
import io.lumine.mythic.lib.script.variable.VariableRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class SimpleVariableRegistry<T extends Variable>
implements VariableRegistry<T> {
    private final Map<String, Function<T, Variable>> registered = new HashMap<String, Function<T, Variable>>();

    @Override
    @NotNull
    public Variable accessVariable(@NotNull T t, @NotNull String name) {
        Function<T, Variable> supplier = this.registered.get(name);
        Validate.notNull(supplier, (String)("Cannot find subvariable '" + name + "' in variable type '" + t.getClass().getAnnotation(VariableMetadata.class).name() + "'"));
        return supplier.apply(t);
    }

    @Override
    public boolean hasVariable(String name) {
        return this.registered.containsKey(name);
    }

    public void registerVariable(String name, Function<T, Variable> supplier) {
        Validate.isTrue((!this.registered.containsKey(name) ? 1 : 0) != 0, (String)"A variable with the same name already exists");
        this.registered.put(name, supplier);
    }
}

