/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill;

import io.lumine.mythic.lib.api.event.skill.PlayerCastSkillEvent;
import io.lumine.mythic.lib.api.event.skill.SkillCastEvent;
import io.lumine.mythic.lib.player.cooldown.CooldownObject;
import io.lumine.mythic.lib.skill.CastingDelayHandler;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.SkillResult;
import io.lumine.mythic.lib.skill.trigger.TriggerMetadata;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public abstract class Skill
implements CooldownObject {
    private final TriggerType trigger;

    public Skill(TriggerType trigger) {
        this.trigger = Objects.requireNonNull(trigger, "Trigger cannot be null");
    }

    public SkillResult cast(TriggerMetadata triggerMeta) {
        return this.cast(triggerMeta.toSkillMetadata(this));
    }

    public <T extends SkillResult> SkillResult cast(SkillMetadata meta) {
        SkillHandler<?> handler = this.getHandler();
        Object result = handler.getResult(meta);
        if (!result.isSuccessful(meta)) {
            return result;
        }
        if (!this.getResult(meta)) {
            return result;
        }
        PlayerCastSkillEvent called1 = new PlayerCastSkillEvent(meta, (SkillResult)result);
        Bukkit.getPluginManager().callEvent((Event)called1);
        if (called1.isCancelled()) {
            return result;
        }
        int delayTicks = (int)(meta.getModifier("delay") * 20.0);
        if (delayTicks <= 0) {
            this.castInstantly(meta, (T)result);
        } else {
            new CastingDelayHandler(meta, (SkillResult)result);
        }
        return result;
    }

    public <T extends SkillResult> void castInstantly(SkillMetadata meta, T result) {
        this.whenCast(meta);
        this.getHandler().whenCast(result, meta);
        Bukkit.getPluginManager().callEvent((Event)new SkillCastEvent(meta, result));
    }

    @NotNull
    public abstract boolean getResult(SkillMetadata var1);

    public abstract void whenCast(SkillMetadata var1);

    public abstract SkillHandler<?> getHandler();

    @NotNull
    public TriggerType getTrigger() {
        return this.trigger;
    }

    public abstract double getModifier(String var1);

    @Override
    public String getCooldownPath() {
        return "skill_" + this.getHandler().getId();
    }
}

