/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def;

import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.SkillResult;
import io.lumine.mythic.lib.util.ParabolicProjectile;
import io.lumine.mythic.lib.version.VersionSound;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.NotNull;

public class Warp
extends SkillHandler<WarpSkillResult> {
    public Warp() {
        this.registerModifiers("range");
    }

    @Override
    @NotNull
    public WarpSkillResult getResult(SkillMetadata meta) {
        return new WarpSkillResult(meta);
    }

    @Override
    public void whenCast(WarpSkillResult result, SkillMetadata skillMeta) {
        Player caster = skillMeta.getCaster().getPlayer();
        caster.getWorld().playSound(caster.getLocation(), Sound.BLOCK_END_PORTAL_FRAME_FILL, 1.0f, 2.0f);
        Location loc = result.getLocation();
        new ParabolicProjectile(caster.getLocation().add(0.0, 1.0, 0.0), loc.clone().add(0.0, 1.0, 0.0), () -> {
            if (caster.isOnline() && !caster.isDead()) {
                caster.teleport(loc);
                caster.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, caster.getLocation().add(0.0, 1.0, 0.0), 0);
                caster.getWorld().spawnParticle(Particle.SPELL_INSTANT, caster.getLocation().add(0.0, 1.0, 0.0), 32, 0.0, 0.0, 0.0, 0.1);
                caster.getWorld().playSound(caster.getLocation(), VersionSound.ENTITY_ENDERMAN_TELEPORT.toSound(), 1.0f, 1.0f);
            }
        }, 2, Particle.SPELL_INSTANT);
    }

    public class WarpSkillResult
    implements SkillResult {
        private final Location loc;

        public WarpSkillResult(SkillMetadata meta) {
            Player caster = meta.getCaster().getPlayer();
            RayTraceResult res = caster.rayTraceBlocks(meta.getModifier("range"), FluidCollisionMode.NEVER);
            Location location = this.loc = res == null ? null : res.getHitPosition().toLocation(caster.getWorld());
            if (this.loc != null) {
                this.loc.setDirection(caster.getEyeLocation().getDirection());
            }
        }

        @Override
        public boolean isSuccessful(SkillMetadata skillMeta) {
            return this.loc != null;
        }

        public Location getLocation() {
            return this.loc;
        }
    }
}

