/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.passive;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.event.PlayerAttackEvent;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.player.skill.PassiveSkill;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.AttackSkillResult;
import io.lumine.mythic.lib.skill.trigger.TriggerMetadata;
import io.lumine.mythic.lib.util.ParabolicProjectile;
import io.lumine.mythic.lib.version.VersionSound;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Power_Mark
extends SkillHandler<AttackSkillResult>
implements Listener {
    public Power_Mark() {
        super(false);
        this.registerModifiers("duration", "stun", "ratio");
    }

    @Override
    public AttackSkillResult getResult(SkillMetadata meta) {
        return new AttackSkillResult(meta);
    }

    @Override
    public void whenCast(AttackSkillResult result, SkillMetadata skillMeta) {
        new PowerMark(skillMeta.getCaster(), skillMeta, skillMeta.getTargetEntity().getLocation());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void a(PlayerAttackEvent event) {
        if (!event.getAttack().getDamage().hasType(DamageType.WEAPON)) {
            return;
        }
        PassiveSkill skill = event.getAttacker().getData().getPassiveSkillMap().getSkill(this);
        if (skill == null) {
            return;
        }
        skill.getTriggeredSkill().cast(new TriggerMetadata(event.getAttacker(), (Entity)event.getEntity()));
    }

    private Vector format(Vector vec) {
        return vec.length() < 0.01 ? new Vector(0, 0, 0) : vec.normalize();
    }

    public class PowerMark
    extends BukkitRunnable
    implements Listener {
        private final PlayerMetadata caster;
        private final Location loc;
        private final double duration;
        private final double ratio;
        private double stun;
        private double accumulate;
        private int j;

        public PowerMark(PlayerMetadata caster, SkillMetadata skillMeta, Location loc) {
            this.caster = caster;
            this.loc = loc;
            loc.getWorld().playSound(loc, Sound.BLOCK_END_PORTAL_FRAME_FILL, 2.0f, 1.0f);
            this.duration = skillMeta.getModifier("duration");
            this.ratio = skillMeta.getModifier("ratio") / 100.0;
            this.stun = skillMeta.getModifier("stun");
            this.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)MythicLib.plugin);
        }

        private void unregister() {
            PlayerAttackEvent.getHandlerList().unregister((Listener)this);
            this.cancel();
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void stackDamage(PlayerAttackEvent event) {
            if (!event.isCancelled() && (double)this.j < 20.0 * (this.duration - 2.0) && this.radiusCheck(event.getEntity().getLocation()) && event.getAttacker().getPlayer().equals(this.caster.getPlayer())) {
                this.accumulate += event.getAttack().getDamage().getDamage() * this.ratio;
                new ParabolicProjectile(event.getEntity().getLocation().add(0.0, event.getEntity().getHeight() / 2.0, 0.0), this.loc, () -> this.loc.getWorld().playSound(this.loc, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f), Color.PURPLE);
            }
        }

        private boolean radiusCheck(Location loc) {
            return loc.getWorld().equals(this.loc.getWorld()) && loc.distanceSquared(this.loc) < 16.0;
        }

        public void run() {
            int n = this.j++;
            if ((double)n > this.duration * 20.0) {
                this.unregister();
                for (double a = 0.0; a < Math.PI * 2; a += 0.36959913571644626) {
                    new ParabolicProjectile(this.loc, this.loc.clone().add(6.0 * Math.cos(a), 0.0, 6.0 * Math.sin(a)), Particle.SPELL_WITCH);
                }
                this.loc.getWorld().playSound(this.loc, Sound.ENTITY_GENERIC_EXPLODE, 2.0f, 0.0f);
                this.loc.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, this.loc.clone().add(0.0, 1.0, 0.0), 16, 2.0, 2.0, 2.0, 0.0);
                this.loc.getWorld().spawnParticle(Particle.EXPLOSION_NORMAL, this.loc.clone().add(0.0, 1.0, 0.0), 24, 0.0, 0.0, 0.0, (double)0.3f);
                this.stun += Math.log(Math.max(1.0, this.accumulate - 10.0)) / 8.0;
                for (Entity entity : UtilityMethods.getNearbyChunkEntities(this.loc)) {
                    if (!(entity.getLocation().distanceSquared(this.loc) < 25.0) || !UtilityMethods.canTarget(this.caster.getPlayer(), entity)) continue;
                    ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, (int)(this.stun * 20.0), 10, false, false));
                    this.caster.attack((LivingEntity)entity, this.accumulate, DamageType.SKILL, DamageType.MAGIC);
                    entity.setVelocity(Power_Mark.this.format(entity.getLocation().subtract(this.loc).toVector().setY(0)).setY(0.3));
                }
                return;
            }
            if (this.j % 2 == 0 && (double)this.j > 20.0 * (this.duration - 2.0)) {
                this.loc.getWorld().playSound(this.loc, VersionSound.BLOCK_NOTE_BLOCK_PLING.toSound(), 1.0f, (float)(1.0 + ((double)this.j - 20.0 * (this.duration - 2.0)) / 40.0));
            }
            double a = (double)this.j / 16.0;
            double r = Math.sqrt(Math.min(this.duration * 2.0 - (double)this.j / 10.0, 4.0)) * 2.0;
            for (double k = 0.0; k < Math.PI * 2; k += 1.2566370614359172) {
                this.loc.getWorld().spawnParticle(Particle.SPELL_WITCH, this.loc.clone().add(r * Math.cos(k + a), 0.0, r * Math.sin(k + a)), 0);
            }
        }
    }
}

