/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.simple;

import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.SimpleSkillResult;
import io.lumine.mythic.lib.version.VersionSound;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class Blink
extends SkillHandler<SimpleSkillResult> {
    private static final double MIN_RANGE = 1.0;

    public Blink() {
        this.registerModifiers("range");
    }

    @Override
    public SimpleSkillResult getResult(SkillMetadata meta) {
        return new SimpleSkillResult();
    }

    @Override
    public void whenCast(SimpleSkillResult result, SkillMetadata skillMeta) {
        Player caster = skillMeta.getCaster().getPlayer();
        double range = Math.max(1.0, skillMeta.getModifier("range"));
        Vector dir2 = caster.getEyeLocation().getDirection();
        caster.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, caster.getLocation().add(0.0, 1.0, 0.0), 0);
        caster.getWorld().spawnParticle(Particle.SPELL_INSTANT, caster.getLocation().add(0.0, 1.0, 0.0), 32, 0.0, 0.0, 0.0, 0.1);
        caster.getWorld().playSound(caster.getLocation(), VersionSound.ENTITY_ENDERMAN_TELEPORT.toSound(), 1.0f, 1.0f);
        RayTraceResult rtResult = caster.getWorld().rayTraceBlocks(caster.getEyeLocation(), dir2, range, FluidCollisionMode.NEVER, true);
        Location loc = rtResult == null || rtResult.getHitBlock() == null ? caster.getLocation().add(dir2.clone().multiply(range)) : rtResult.getHitPosition().add(rtResult.getHitBlockFace().getDirection().multiply(0.3)).toLocation(caster.getWorld());
        loc.setYaw(caster.getLocation().getYaw());
        loc.setPitch(caster.getLocation().getPitch());
        caster.teleport(loc);
        caster.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, caster.getLocation().add(0.0, 1.0, 0.0), 0);
        caster.getWorld().spawnParticle(Particle.SPELL_INSTANT, caster.getLocation().add(0.0, 1.0, 0.0), 32, 0.0, 0.0, 0.0, 0.1);
    }
}

