/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.simple;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.util.TemporaryListener;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.SimpleSkillResult;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Blizzard
extends SkillHandler<SimpleSkillResult> {
    public Blizzard() {
        this.registerModifiers("duration", "damage", "inaccuracy", "force");
    }

    @Override
    public SimpleSkillResult getResult(SkillMetadata meta) {
        return new SimpleSkillResult();
    }

    @Override
    public void whenCast(SimpleSkillResult result, final SkillMetadata skillMeta) {
        final double duration = skillMeta.getModifier("duration") * 10.0;
        final double force = skillMeta.getModifier("force");
        final double inaccuracy = skillMeta.getModifier("inaccuracy");
        final Player caster = skillMeta.getCaster().getPlayer();
        new BukkitRunnable(){
            final CustomSnowballRegistry handler;
            int j;
            {
                this.handler = new CustomSnowballRegistry(skillMeta.getModifier("damage"));
                this.j = 0;
            }

            public void run() {
                int n = this.j++;
                if ((double)n > duration) {
                    this.handler.close(100L);
                    this.cancel();
                    return;
                }
                Location loc = caster.getEyeLocation();
                loc.setPitch((float)((double)loc.getPitch() + (random.nextDouble() - 0.5) * inaccuracy));
                loc.setYaw((float)((double)loc.getYaw() + (random.nextDouble() - 0.5) * inaccuracy));
                loc.getWorld().playSound(loc, Sound.ENTITY_SNOWBALL_THROW, 1.0f, 1.0f);
                Snowball snowball = (Snowball)caster.launchProjectile(Snowball.class);
                snowball.setVelocity(loc.getDirection().multiply(1.3 * force));
                this.handler.entities.add(snowball.getUniqueId());
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 2L);
    }

    public class CustomSnowballRegistry
    extends TemporaryListener {
        private final List<UUID> entities;
        private final double damage;

        public CustomSnowballRegistry(double damage) {
            super(EntityDamageByEntityEvent.getHandlerList());
            this.entities = new ArrayList<UUID>();
            this.damage = damage;
        }

        @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
        public void a(EntityDamageByEntityEvent event) {
            if (this.entities.contains(event.getDamager().getUniqueId())) {
                event.setDamage(this.damage);
            }
        }

        @Override
        public void whenClosed() {
        }
    }
}

