/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.simple;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.util.TemporaryListener;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.SimpleSkillResult;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Chicken_Wraith
extends SkillHandler<SimpleSkillResult> {
    public Chicken_Wraith() {
        this.registerModifiers("damage", "duration", "inaccuracy", "force");
    }

    @Override
    public SimpleSkillResult getResult(SkillMetadata meta) {
        return new SimpleSkillResult();
    }

    @Override
    public void whenCast(SimpleSkillResult result, final SkillMetadata skillMeta) {
        final double duration = skillMeta.getModifier("duration") * 10.0;
        final double force = skillMeta.getModifier("force");
        final double inaccuracy = skillMeta.getModifier("inaccuracy");
        final Player caster = skillMeta.getCaster().getPlayer();
        new BukkitRunnable(){
            final CustomEggRegistry handler;
            int j;
            {
                this.handler = new CustomEggRegistry(skillMeta.getModifier("damage"));
                this.j = 0;
            }

            public void run() {
                int n = this.j++;
                if ((double)n > duration) {
                    this.handler.close(100L);
                    this.cancel();
                    return;
                }
                Location loc = caster.getEyeLocation();
                loc.setPitch((float)((double)loc.getPitch() + (random.nextDouble() - 0.5) * inaccuracy));
                loc.setYaw((float)((double)loc.getYaw() + (random.nextDouble() - 0.5) * inaccuracy));
                loc.getWorld().playSound(loc, Sound.ENTITY_CHICKEN_EGG, 1.0f, 1.0f);
                Egg egg = (Egg)caster.launchProjectile(Egg.class);
                egg.setVelocity(loc.getDirection().multiply(1.3 * force));
                this.handler.entities.add(egg.getEntityId());
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 2L);
    }

    public class CustomEggRegistry
    extends TemporaryListener {
        private final List<Integer> entities;
        private final double damage;

        public CustomEggRegistry(double damage) {
            super(EntityDamageByEntityEvent.getHandlerList(), PlayerEggThrowEvent.getHandlerList());
            this.entities = new ArrayList<Integer>();
            this.damage = damage;
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void a(PlayerEggThrowEvent event) {
            if (this.entities.contains(event.getEgg().getEntityId())) {
                event.setHatching(false);
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void b(EntityDamageByEntityEvent event) {
            if (this.entities.contains(event.getDamager().getEntityId())) {
                event.setDamage(this.damage);
            }
        }

        @Override
        public void whenClosed() {
        }
    }
}

