/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.simple;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.event.PlayerAttackEvent;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.SimpleSkillResult;
import io.lumine.mythic.lib.util.SmallParticleEffect;
import io.lumine.mythic.lib.version.VersionSound;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Empowered_Attack
extends SkillHandler<SimpleSkillResult> {
    private static final double PARTICLES_PER_METER = 5.0;

    public Empowered_Attack() {
        this.registerModifiers("radius", "ratio", "extra");
    }

    @Override
    public SimpleSkillResult getResult(SkillMetadata meta) {
        return new SimpleSkillResult();
    }

    @Override
    public void whenCast(SimpleSkillResult result, SkillMetadata skillMeta) {
        Player caster = skillMeta.getCaster().getPlayer();
        caster.playSound(caster.getLocation(), Sound.BLOCK_END_PORTAL_FRAME_FILL, 1.0f, 1.0f);
        new EmpoweredAttack(skillMeta.getCaster(), skillMeta.getModifier("extra"), skillMeta.getModifier("ratio"), skillMeta.getModifier("radius"));
    }

    private void drawVector(Location loc, Vector vec) {
        double steps = vec.length() * 5.0;
        Vector v = vec.clone().normalize().multiply(0.2);
        int j = 0;
        while ((double)j < Math.min(steps, 124.0)) {
            loc.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, loc.add(v), 0);
            ++j;
        }
    }

    public class EmpoweredAttack
    implements Listener {
        private final PlayerMetadata caster;
        private final double c;
        private final double r;
        private final double rad;

        public EmpoweredAttack(PlayerMetadata caster, double extra, double ratio, double radius) {
            this.caster = caster;
            this.c = 1.0 + extra / 100.0;
            this.r = ratio / 100.0;
            this.rad = radius;
            if (caster.getData().isOnline()) {
                new SmallParticleEffect((Entity)caster.getPlayer(), Particle.FIREWORKS_SPARK);
            }
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)MythicLib.plugin);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicLib.plugin, this::close, 80L);
        }

        private void close() {
            PlayerAttackEvent.getHandlerList().unregister((Listener)this);
        }

        @EventHandler
        public void a(PlayerAttackEvent event) {
            if (!this.caster.getData().isOnline()) {
                return;
            }
            if (event.getAttacker().getPlayer().equals(this.caster.getPlayer()) && event.getAttack().getDamage().hasType(DamageType.WEAPON)) {
                this.close();
                LivingEntity target = event.getEntity();
                Location loc = target.getLocation().add(0.0, target.getHeight() / 2.0, 0.0);
                for (int j = 0; j < 3; ++j) {
                    Location clone = loc.clone();
                    double a = random.nextDouble() * Math.PI * 2.0;
                    loc.add(Math.cos(a), 5.0, Math.sin(a));
                    Empowered_Attack.this.drawVector(clone, loc.clone().subtract(clone).toVector());
                }
                target.getWorld().playSound(target.getLocation(), VersionSound.ENTITY_FIREWORK_ROCKET_BLAST.toSound(), 2.0f, 0.5f);
                target.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, target.getLocation().add(0.0, target.getHeight() / 2.0, 0.0), 32, 0.0, 0.0, 0.0, 0.2);
                double sweep = event.getAttack().getDamage().getDamage() * this.r;
                Location src = target.getLocation().add(0.0, target.getHeight() / 2.0, 0.0);
                for (Entity entity : target.getNearbyEntities(this.rad, this.rad, this.rad)) {
                    if (!UtilityMethods.canTarget(this.caster.getPlayer(), entity)) continue;
                    Empowered_Attack.this.drawVector(src, entity.getLocation().add(0.0, entity.getHeight() / 2.0, 0.0).subtract(src).toVector());
                    event.getAttacker().attack((LivingEntity)entity, sweep, DamageType.SKILL, DamageType.PHYSICAL);
                }
                event.getAttack().getDamage().multiplicativeModifier(this.c, DamageType.WEAPON);
            }
        }
    }
}

