/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.simple;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.SimpleSkillResult;
import io.lumine.mythic.lib.version.VersionSound;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Magical_Shield
extends SkillHandler<SimpleSkillResult> {
    public Magical_Shield() {
        this.registerModifiers("power", "radius", "duration");
    }

    @Override
    public SimpleSkillResult getResult(SkillMetadata meta) {
        return new SimpleSkillResult(meta.getCaster().getPlayer().isOnGround());
    }

    @Override
    public void whenCast(SimpleSkillResult result, SkillMetadata skillMeta) {
        double duration = skillMeta.getModifier("duration");
        double radiusSquared = Math.pow(skillMeta.getModifier("radius"), 2.0);
        double power = skillMeta.getModifier("power") / 100.0;
        new MagicalShieldEffect(skillMeta.getCaster().getPlayer(), duration, radiusSquared, power);
    }

    public class MagicalShieldEffect
    extends BukkitRunnable
    implements Listener {
        private final Location loc;
        private final double duration;
        private final double radius;
        private final double power;
        private int ti = 0;

        public MagicalShieldEffect(Player caster, double duration, double radius, double power) {
            this.loc = caster.getLocation().clone();
            this.duration = duration;
            this.radius = radius;
            this.power = power;
            caster.getWorld().playSound(caster.getLocation(), VersionSound.ENTITY_ENDERMAN_TELEPORT.toSound(), 3.0f, 0.0f);
            this.runTaskTimer((Plugin)MythicLib.plugin, 0L, 3L);
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)MythicLib.plugin);
        }

        private void close() {
            this.cancel();
            EntityDamageEvent.getHandlerList().unregister((Listener)this);
        }

        @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
        public void a(EntityDamageEvent event) {
            if (event.getEntity() instanceof Player && event.getEntity().getWorld().equals(this.loc.getWorld()) && event.getEntity().getLocation().distanceSquared(this.loc) < this.radius) {
                event.setDamage(event.getDamage() * (1.0 - this.power));
            }
        }

        public void run() {
            int n = this.ti++;
            if ((double)n > this.duration * 20.0 / 3.0) {
                this.close();
            }
            for (double j = 0.0; j < 1.5707963267948966; j += Math.PI / (double)(28 + random.nextInt(5))) {
                for (double i = 0.0; i < Math.PI * 2; i += Math.PI / (double)(14 + random.nextInt(5))) {
                    this.loc.getWorld().spawnParticle(Particle.REDSTONE, this.loc.clone().add(2.5 * Math.cos(i + j) * Math.sin(j), 2.5 * Math.cos(j), 2.5 * Math.sin(i + j) * Math.sin(j)), 1, (Object)new Particle.DustOptions(Color.FUCHSIA, 1.0f));
                }
            }
        }
    }
}

