/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.target;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.TargetSkillResult;
import io.lumine.mythic.lib.version.VersionSound;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class Blind
extends SkillHandler<TargetSkillResult> {
    public Blind() {
        this.registerModifiers("duration");
    }

    @Override
    public TargetSkillResult getResult(SkillMetadata meta) {
        return new TargetSkillResult(meta);
    }

    @Override
    public void whenCast(TargetSkillResult result, SkillMetadata skillMeta) {
        LivingEntity target = result.getTarget();
        Player caster = skillMeta.getCaster().getPlayer();
        target.getWorld().playSound(target.getLocation(), VersionSound.ENTITY_ENDERMAN_HURT.toSound(), 1.0f, 2.0f);
        for (double i = 0.0; i < Math.PI * 2; i += 0.1308996938995747) {
            for (double j = 0.0; j < 2.0; j += 1.0) {
                Location loc = target.getLocation();
                Vector vec = UtilityMethods.rotate(new Vector(Math.cos(i), 1.0 + Math.cos(i + Math.PI * j) * 0.5, Math.sin(i)), caster.getLocation().getDirection());
                loc.getWorld().spawnParticle(Particle.REDSTONE, loc.add(vec), 1, (Object)new Particle.DustOptions(Color.BLACK, 1.0f));
            }
        }
        target.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, (int)(skillMeta.getModifier("duration") * 20.0), 0));
    }
}

