/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.target;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.TargetSkillResult;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Death_Mark
extends SkillHandler<TargetSkillResult> {
    public Death_Mark() {
        this.registerModifiers("damage", "duration", "amplifier");
    }

    @Override
    public TargetSkillResult getResult(SkillMetadata meta) {
        return new TargetSkillResult(meta);
    }

    @Override
    public void whenCast(TargetSkillResult result, final SkillMetadata skillMeta) {
        final LivingEntity target = result.getTarget();
        final double duration = skillMeta.getModifier("duration") * 20.0;
        final double dps = skillMeta.getModifier("damage") / duration * 20.0;
        new BukkitRunnable(){
            double ti = 0.0;

            public void run() {
                this.ti += 1.0;
                if (this.ti > duration || target == null || target.isDead()) {
                    this.cancel();
                    return;
                }
                target.getWorld().spawnParticle(Particle.SPELL_MOB, target.getLocation(), 4, 0.2, 0.0, 0.2, 0.0);
                if (this.ti % 20.0 == 0.0) {
                    skillMeta.getCaster().attack(target, dps, false, DamageType.SKILL, DamageType.MAGIC);
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
        target.getWorld().playSound(target.getLocation(), Sound.ENTITY_BLAZE_HURT, 1.0f, 2.0f);
        target.removePotionEffect(PotionEffectType.SLOW);
        target.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, (int)duration, (int)skillMeta.getModifier("amplifier")));
    }
}

