/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.target;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.TargetSkillResult;
import io.lumine.mythic.lib.version.VersionSound;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Weaken_Target
extends SkillHandler<TargetSkillResult>
implements Listener {
    public final Map<UUID, WeakenedInfo> marked = new HashMap<UUID, WeakenedInfo>();

    public Weaken_Target() {
        this.registerModifiers("duration", "extra-damage");
    }

    @Override
    public TargetSkillResult getResult(SkillMetadata meta) {
        return new TargetSkillResult(meta);
    }

    @Override
    public void whenCast(TargetSkillResult result, final SkillMetadata skillMeta) {
        final LivingEntity target = result.getTarget();
        this.marked.put(target.getUniqueId(), new WeakenedInfo(skillMeta.getModifier("extra-damage")));
        this.effect(target.getLocation());
        target.getWorld().playSound(target.getLocation(), VersionSound.ENTITY_ENDERMAN_HURT.toSound(), 2.0f, 1.5f);
        new BukkitRunnable(){
            final long duration;
            {
                this.duration = (long)(skillMeta.getModifier("duration") * 1000.0);
            }

            public void run() {
                if (!Weaken_Target.this.marked.containsKey(target.getUniqueId()) || Weaken_Target.this.marked.get(target.getUniqueId()).date + this.duration < System.currentTimeMillis()) {
                    this.cancel();
                    return;
                }
                for (double j = 0.0; j < Math.PI * 2; j += 0.17453292519943295) {
                    target.getWorld().spawnParticle(Particle.SMOKE_NORMAL, target.getLocation().clone().add(Math.cos(j) * 0.7, 0.1, Math.sin(j) * 0.7), 0);
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 20L);
    }

    @EventHandler
    public void a(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK && event.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION && event.getCause() != EntityDamageEvent.DamageCause.PROJECTILE) {
            return;
        }
        Entity entity = event.getEntity();
        if (this.marked.containsKey(entity.getUniqueId())) {
            event.setDamage(event.getDamage() * (1.0 + this.marked.get(entity.getUniqueId()).extraDamage));
            this.effect(entity.getLocation());
            this.marked.remove(entity.getUniqueId());
            entity.getWorld().playSound(entity.getLocation(), VersionSound.ENTITY_ENDERMAN_DEATH.toSound(), 2.0f, 2.0f);
        }
    }

    @EventHandler
    public void b(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item.getType() == Material.MILK_BUCKET && this.marked.containsKey(player.getUniqueId())) {
            this.marked.remove(player.getUniqueId());
            player.getWorld().playSound(player.getLocation(), VersionSound.ENTITY_ENDERMAN_DEATH.toSound(), 2.0f, 2.0f);
        }
    }

    private void effect(final Location loc) {
        new BukkitRunnable(){
            double y = 0.0;

            public void run() {
                for (int j = 0; j < 3; ++j) {
                    this.y += 0.07;
                    for (int k = 0; k < 3; ++k) {
                        loc.getWorld().spawnParticle(Particle.REDSTONE, loc.clone().add(Math.cos(this.y * Math.PI + (double)k * Math.PI * 2.0 / 3.0) * (3.0 - this.y) / 2.5, this.y, Math.sin(this.y * Math.PI + (double)k * Math.PI * 2.0 / 3.0) * (3.0 - this.y) / 2.5), 1, (Object)new Particle.DustOptions(Color.BLACK, 1.0f));
                    }
                }
                if (this.y > 3.0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
    }

    public class WeakenedInfo {
        private final long date = System.currentTimeMillis();
        private final double extraDamage;

        public WeakenedInfo(double extraDamage) {
            this.extraDamage = extraDamage / 100.0;
        }
    }
}

