/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.sql;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.sql.MMODataSource;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class DataSynchronizer {
    private final MMODataSource dataSource;
    private final MMOPlayerData mmoPlayerData;
    private final String tableName;
    private final String uuidFieldName;
    private final long start = System.currentTimeMillis();
    private int tries;

    public DataSynchronizer(String tableName, String uuidFieldName, MMODataSource dataSource, UUID uuid) {
        this.tableName = tableName;
        this.uuidFieldName = uuidFieldName;
        this.mmoPlayerData = MMOPlayerData.get(uuid);
        this.dataSource = dataSource;
    }

    public void tryToFetchData() {
        if (!this.mmoPlayerData.isOnline()) {
            UtilityMethods.debug(this.dataSource.getPlugin(), "SQL", "Stopped data retrieval for '" + this.mmoPlayerData.getUniqueId() + "' as they went offline");
            return;
        }
        ++this.tries;
        CompletableFuture.runAsync(() -> {
            try {
                Connection connection = this.dataSource.getConnection();
                PreparedStatement prepared = connection.prepareStatement("SELECT * FROM `" + this.tableName + "` WHERE `" + this.uuidFieldName + "` = ?;");
                prepared.setString(1, this.mmoPlayerData.getUniqueId().toString());
                try {
                    UtilityMethods.debug(this.dataSource.getPlugin(), "SQL", "Trying to load data of " + this.mmoPlayerData.getUniqueId());
                    ResultSet result = prepared.executeQuery();
                    if (result.next()) {
                        if (this.tries > MythicLib.plugin.getMMOConfig().maxSyncTries || result.getInt("is_saved") == 1) {
                            this.confirmReception(connection);
                            this.loadData(result);
                            UtilityMethods.debug(this.dataSource.getPlugin(), "SQL", "Found and loaded data of '" + this.mmoPlayerData.getUniqueId() + "'");
                            UtilityMethods.debug(this.dataSource.getPlugin(), "SQL", "Time taken: " + (System.currentTimeMillis() - this.start) + "ms");
                        } else {
                            UtilityMethods.debug(this.dataSource.getPlugin(), "SQL", "Did not load data of '" + this.mmoPlayerData.getUniqueId() + "' as 'is_saved' is set to 0, trying again in 1s");
                            Bukkit.getScheduler().runTaskLater((Plugin)MythicLib.plugin, this::fetch, 20L);
                        }
                    } else {
                        this.confirmReception(connection);
                        this.loadEmptyData();
                        UtilityMethods.debug(this.dataSource.getPlugin(), "SQL", "Found empty data for '" + this.mmoPlayerData.getUniqueId() + "', loading default...");
                    }
                }
                catch (Throwable throwable) {
                    MythicLib.plugin.getLogger().log(Level.WARNING, "Could not load player data of " + this.mmoPlayerData.getUniqueId());
                    throwable.printStackTrace();
                }
                finally {
                    prepared.close();
                    connection.close();
                }
            }
            catch (SQLException throwable) {
                MythicLib.plugin.getLogger().log(Level.WARNING, "Could not load player data of " + this.mmoPlayerData.getUniqueId());
                throwable.printStackTrace();
            }
        });
    }

    public boolean fetch() {
        this.tryToFetchData();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirmReception(Connection connection) throws SQLException {
        prepared1.setString(1, this.mmoPlayerData.getUniqueId().toString());
        try (PreparedStatement prepared1 = connection.prepareStatement("INSERT INTO " + this.tableName + "(`uuid`, `is_saved`) VALUES(?, 0) ON DUPLICATE KEY UPDATE `is_saved` = 0;");){
            prepared1.executeUpdate();
        }
    }

    public abstract void loadData(ResultSet var1) throws SQLException, IOException, ClassNotFoundException;

    public abstract void loadEmptyData();
}

