/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.sql;

import io.lumine.mythic.lib.sql.hikari.HikariConfig;
import io.lumine.mythic.lib.sql.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.file.FileConfiguration;

public abstract class NewDataSource
extends HikariDataSource {
    private final boolean debugMode;

    public NewDataSource(FileConfiguration config) {
        super(NewDataSource.loadConfig(config));
        this.debugMode = config.getBoolean("debug");
        this.whenLoaded();
    }

    private static HikariConfig loadConfig(FileConfiguration cfg) {
        Validate.isTrue((boolean)cfg.getBoolean("enabled", false), (String)"MySQL is not enabled");
        HikariConfig config = new HikariConfig();
        config.setPoolName("MMO-hikari");
        String databaseUrl = "jdbc:mysql://" + cfg.getString("host", "localhost") + ":" + cfg.getString("port", "3306") + "/" + cfg.getString("database", "minecraft");
        config.setJdbcUrl(databaseUrl);
        config.setUsername(cfg.getString("user", "mmolover"));
        config.setPassword(cfg.getString("pass", "ILoveAria"));
        config.setMaximumPoolSize(cfg.getInt("maxPoolSize", 10));
        config.setMaxLifetime(cfg.getLong("maxLifeTime", 300000L));
        config.setConnectionTimeout(cfg.getLong("connectionTimeOut", 10000L));
        config.setLeakDetectionThreshold(cfg.getLong("leakDetectionThreshold", 150000L));
        if (cfg.isConfigurationSection("properties")) {
            for (String key : cfg.getConfigurationSection("properties").getKeys(false)) {
                config.addDataSourceProperty(key, cfg.getString("properties." + key));
            }
        }
        return config;
    }

    protected abstract void whenLoaded();

    public void getResult(String sql, Consumer<ResultSet> supplier) {
        this.execute(connection -> {
            try {
                supplier.accept(connection.prepareStatement(sql).executeQuery());
            }
            catch (SQLException exception) {
                exception.printStackTrace();
            }
        });
    }

    public CompletableFuture<Void> getResultAsync(String sql, Consumer<ResultSet> supplier) {
        return CompletableFuture.runAsync(() -> this.getResult(sql, supplier));
    }

    public void executeUpdate(String sql) {
        this.execute(connection -> {
            try {
                connection.prepareStatement(sql).executeUpdate();
            }
            catch (SQLException exception) {
                exception.printStackTrace();
            }
        });
    }

    public CompletableFuture<Void> executeUpdateAsync(String sql) {
        return CompletableFuture.runAsync(() -> this.executeUpdate(sql));
    }

    public void execute(Consumer<Connection> execute) {
        try {
            execute.accept(this.getConnection());
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }
}

